% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{hw_H}
\alias{hw_H}
\title{KDE bandwidth for residual variability in height/weight}
\format{
A named list with 10 elements, each a matrix with 2 rows and 2
 columns. Each list element corresponds to, and is named for, one combination
 of NHANES sex categories (Male and Female) and NHANES race/ethnicity
 categories (Mexican American, Other Hispanic, Non-Hispanic White,
 Non-Hispanic Black, and Other).
}
\usage{
hw_H
}
\description{
Bandwidths used for a two-dimensional kernel density estimation of the joint
distribution of residual errors around smoothing spline fits of height vs. age
and weight vs. age for NHANES respondents in each of ten combinations of sex
and race/ethnicity categories.
}
\details{
Each matrix is a variance-covariance matrix for a two-dimensional normal
distribution: this is the bandwidth to be used for a two-dimensional kernel
density estimation (KDE) (using a two-dimensional normal kernel) of the joint
distribution of residual errors around smoothing spline fits of height vs. age
and weight vs. age for NHANES respondents in the specified sex and
race/ethnicity category. Optimal bandwidths were pre-calculated by doing the
smoothing spline fits, getting the residuals, then calling
\code{\link[ks]{kde}} on the residuals (which calls \code{\link[ks]{Hpi}} to
compute the plug-in bandwidth).

Used by HTTK-Pop only in "virtual individuals" mode (i.e.
\code{\link{httkpop_generate}} with \code{method = "v"}), in
\code{\link{gen_height_weight}}.
}
\references{
\insertRef{ring2017identifying}{httk}
}
\author{
Caroline Ring
}
\keyword{data}
\keyword{httk-pop}
