% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invitro_mc.R
\name{invitro_mc}
\alias{invitro_mc}
\title{Monte Carlo for in vitro toxicokinetic parameters including uncertainty and variability.}
\usage{
invitro_mc(
  parameters.dt = NULL,
  samples,
  fup.meas.mc = TRUE,
  fup.pop.mc = TRUE,
  clint.meas.mc = TRUE,
  clint.pop.mc = TRUE,
  fup.meas.cv = 0.4,
  clint.meas.cv = 0.3,
  fup.pop.cv = 0.3,
  clint.pop.cv = 0.3,
  caco2.meas.sd = 0.3,
  caco2.pop.sd = 0.3,
  Caco2.Fgut = TRUE,
  Caco2.Fabs = TRUE,
  keepit100 = FALSE,
  poormetab = TRUE,
  fup.lod = 0.01,
  fup.censored.dist = FALSE,
  adjusted.Funbound.plasma = TRUE,
  adjusted.Clint = TRUE,
  clint.pvalue.threshold = 0.05,
  minimum.Funbound.plasma = 1e-04
)
}
\arguments{
\item{parameters.dt}{A data table of physiological and chemical-specific parameters}

\item{samples}{The number of samples to draw.}

\item{fup.meas.mc}{Logical -- should we perform measurment (uncertainty)
Monte Carlo for \code{Funbound.plasma} values (Default TRUE). If FALSE, 
the user may choose to provide columns for "unadjusted.Funbound.plasma" or
"fup.mean" from their own methods.}

\item{fup.pop.mc}{Logical -- should we perform population (variability)
Monte Carlo for \code{Funbound.plasma} values (Default TRUE)}

\item{clint.meas.mc}{Logical -- should we perform measurment (uncertainty)
Monte Carlo for \code{Clint} values (Default TRUE)}

\item{clint.pop.mc}{Logical -- should we perform population (variability)
Monte Carlo for \code{Clint} values (Default TRUE)}

\item{fup.meas.cv}{Coefficient of variation of distribution of measured
\code{Funbound.plasma} values.}

\item{clint.meas.cv}{Coefficient of variation of distribution of measured 
\code{Clint} values.}

\item{fup.pop.cv}{Coefficient of variation of distribution of population
\code{Funbound.plasma} values.}

\item{clint.pop.cv}{Coefficient of variation of distribution of population
\code{Clint} values.}

\item{caco2.meas.sd}{Standard deviation of the measured oral absorption - numeric value (Default 0.3).}

\item{caco2.pop.sd}{Standard deviation of the population level oral absorption - numeric value (Default 0.3).}

\item{Caco2.Fgut}{= TRUE uses Caco2.Pab to calculate 
fgut.oral, otherwise fgut.oral = \code{Fgut}.}

\item{Caco2.Fabs}{= TRUE uses Caco2.Pab to calculate
fabs.oral, otherwise fabs.oral = \code{Fabs}.}

\item{keepit100}{= TRUE overwrites Fabs and Fgut with 1 (i.e. 100 percent) regardless of other settings.}

\item{poormetab}{Logical. Whether to include poor metabolizers in the Clint
distribution or not.}

\item{fup.lod}{The average limit of detection for \code{Funbound.plasma}, below
which distribution will be censored if fup.censored.dist is TRUE. Default 0.01.}

\item{fup.censored.dist}{Logical. Whether to draw \code{Funbound.plasma} from a
censored distribution or not.}

\item{adjusted.Funbound.plasma}{Uses the
\insertCite{pearce2017evaluation;textual}{httk} lipid binding adjustment
for Funbound.plasma when set to TRUE (Default).}

\item{adjusted.Clint}{Uses \insertCite{kilford2008hepatocellular;textual}{httk}
hepatocyte incubation
binding adjustment for Clint when set to TRUE (Default).}

\item{clint.pvalue.threshold}{Hepatic clearance for chemicals where the in
vitro clearance assay result has a p-values greater than the threshold are
set to zero.}

\item{minimum.Funbound.plasma}{Monte Carlo draws less than this value are set 
equal to this value (default is 0.0001 -- half the lowest measured Fup in our
dataset).}

\item{parameters}{A list of chemical-specific model parameters containing at
least Funbound.plasma, Clint, and Fhep.assay.correction.}
}
\value{
A data.table with three columns: \code{Funbound.plasma} and
\code{Clint}, containing the sampled values, and
\code{Fhep.assay.correction}, containing the value for fraction unbound in
hepatocyte assay.
}
\description{
Given a CAS in the HTTK data set, a virtual population from HTTK-Pop, some
user specifications on the assumed distributions of Funbound.plasma and
Clint, draw "individual" values of Funbound.plasma and Clint from those
distributions. The methodology for this function was developed and described
by \insertCite{wambaugh2019assessing;textual}{httk}
(\doi{10.1093/toxsci/kfz205}).
}
\details{
The Monte Carlo methods used here were recently updated and described by
\insertCite{breen2022simulating;textual}{httk}.
}
\examples{
\donttest{
#Simply generate a virtual population of 100 individuals,
#using the direct-resampling method
set.seed(42)

# Pull mean chemical=specific values:
chem.props <- parameterize_pbtk(chem.name="bisphenolb")

# Convert to data.table with one row per sample:
parameters.dt <- monte_carlo(chem.props,samples=100)

# Use httk-pop to generate a population:
pop <- httkpop_generate(method='direct resampling', nsamp=100)

# Overwrite parameters specified by httk-pop:
parameters.dt[,names(pop):=pop]

# Vary in vitro parameters:
parameters.dt <- invitro_mc(parameters.dt,samples=100)
}

}
\references{
\insertAllCited{}
}
\author{
Caroline Ring and John Wambaugh
}
\keyword{in-vitro}
\keyword{monte-carlo}
