% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{mcnally_dt}
\alias{mcnally_dt}
\title{Reference tissue masses and flows from tables in McNally et al. (2014)}
\format{
A data.table with variables: \describe{\item{\code{tissue}}{Body
 tissue} \item{\code{gender}}{Gender: Male or Female}
 \item{\code{mass_ref}}{Reference mass in kg, from Reference Man}
 \item{\code{mass_cv}}{Coefficient of variation for mass}
 \item{\code{mass_dist}}{Distribution for mass: Normal or Log-normal}
 \item{\code{flow_ref}}{Reference flow in L/h, from Reference Man}
 \item{\code{flow_cv}}{Coefficient of variation for flow (all normally
 distributed)} \item{\code{height_ref}}{Reference heights (by gender)}
 \item{\code{CO_ref}}{Reference cardiac output by gender}
 \item{\code{flow_frac}}{Fraction of CO flowing to each tissue:
 \code{flow_ref}/\code{CO_ref}}}
}
\source{
\insertRef{mcnally2014popgen}{httk}
}
\usage{
mcnally_dt
}
\description{
Reference tissue masses, flows, and residual variance distributions from
Tables 1, 4, and 5 of McNally et al. 2014 (\doi{https://doi.org/10.1016/j.tox.2013.07.009}).
}
\references{
\insertRef{mcnally2014popgen}{httk}

\insertRef{ring2017identifying}{httk}
}
\author{
Caroline Ring
}
\keyword{data}
\keyword{httk-pop}
