% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-url.R
\name{create_s3_url}
\alias{create_s3_url}
\title{Create a URL to a file in an S3 bucket}
\usage{
create_s3_url(base_fs, base_path)
}
\arguments{
\item{base_fs}{character string. Path of the base s3 file system (bucket) in the
cloud. Can be extracted from the object of class \verb{<SubTreeFileSystem>} using the
\verb{$base_fs} field, followed by the \verb{$base_path}.}

\item{base_path}{character string. Path to the file in relation to \code{base_fs}.
Can be extracted from the object of class \verb{<SubTreeFileSystem>} using the
\verb{$base_path}.}
}
\value{
A character string of the URL to the file in s3.
}
\description{
Create a URL to a file in an S3 bucket
}
\examples{
create_s3_url(
  base_fs = "hubverse/hubutils/testhubs/simple/",
  base_path = "hub-config/admin.json"
)
\dontshow{if (asNamespace("hubUtils")$not_rcmd_check() && requireNamespace("arrow", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Create a URL from an object of class `<SubTreeFileSystem>` of an s3 hub
hub_path <- arrow::s3_bucket("hubverse/hubutils/testhubs/simple/")
create_s3_url(hub_path$base_path, "hub-config/admin.json")
config_path <- hub_path$path("hub-config/admin.json")
# Create a URL from an object of class `<SubTreeFileSystem>` of the path to
# a config file in an s3 hub
create_s3_url(config_path$base_fs$base_path, config_path$base_path)
\dontshow{\}) # examplesIf}
}
