% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties-table.R
\name{caption}
\alias{caption}
\alias{caption<-}
\alias{set_caption}
\title{Set the table caption}
\usage{
caption(ht)

caption(ht) <- value

set_caption(ht, value)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A string. Set to \code{NA} to reset to the default, which is \code{NA_character_}.}
}
\value{
\code{property()} returns the property value(s).
\code{set_property()} and \code{map_property()} return the modified huxtable.
}
\description{
By default, captions are displayed above the table. You can change this
with \code{\link[=caption_pos]{caption_pos()}}.
}
\details{
Captions are not escaped. See the example for a workaround.
}
\examples{

set_caption(jams, "Pots of jam for sale")
# escape caption characters:
caption(jams) <- sanitize(
  "Make $$$ with jam",
  type = "latex"
)

}
\seealso{
Other caption properties: 
\code{\link{caption_pos}()},
\code{\link{caption_width}()}
}
\concept{caption properties}
