% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper.R
\name{get.states}
\alias{get.states}
\title{Get states}
\usage{
get.states(model)
}
\arguments{
\item{model}{fitted \code{hydroState} model object.}
}
\value{
data frame of results to evaluate the rainfall-runoff states over time
}
\description{
\code{get.states} uses the Viterbi algorithm to globally decode the model and estimate the most probable sequence of states.
}
\details{
\code{get.states}

These dataframe of results include:
\itemize{
\item{time-step:} year and possibly either season or month for subannual analysis
\item{Viterbi State Number:} state number (i.e. 1, 2, or 3) to differentiate states
\item{Obs. flow:} streamflow observations
\item{Viterbi Flow:} flow values of the Viterbi state including the 5\\% and 95\\% confidence intervals. These are the most likely flow state values at each time-step of the given states.
\item{Normal State Flow:} flow values of the normal state including the 5\\% and 95\\% confidence intervals. These Normal state flow values are the values from the normal state at each time-step. When the most likely state is the Normal state for a time-step, the Viterbi flow state value equals the Normal flow state value. This Normal state can be visualized relative to the most likely Viterbi state in the "dep.variable" plot from \code{plot.states}.
\item{Conditional Prob:} conditional probabilities for each state show the probability of remaining in the given state. When the conditional probability is closer to 1, there is a higher probability that hydroState model remains in that state for the next time-step.
\item{Emission Density:} emission density for each state is the result of multiplying the conditional probabilities by the transition probabilities at each timestep.
}
}
\examples{
# Load fitted model
data(model.annual.fitted.221201)

## Set initial year to set state names
model.annual.fitted.221201 =
                setInitialYear(model = model.annual.fitted.221201,
                               initial.year = 1990)

## Get states
model.annual.fitted.221201.states =
                get.states(model = model.annual.fitted.221201)

}
\keyword{get}
\keyword{results}
\keyword{states}
