\name{NBA}
\alias{NBA}
\alias{NBA_likelihood}
\alias{NBA_maxp}
\alias{NBA_table}
\alias{basketball}
\docType{data}
\title{Basketball dataset}
\description{
A point-by-point analysis of a basketball game
}
\usage{data(NBA)}
\details{

Dataset \code{NBA_table} is a dataframe contains a point-by-point
analysis of a basketball match.  Each row corresponds to a point scored.
The first column is the time of the score, the second is the number of
points scored, the third shows which team had possession at the start of
play, and the fourth shows which team scored.  The other columns show
the players.  Table entries show whether or not that particular player
was on the pitch when the point was scored.   

Likelihood function \code{NBA} is a \code{hyper2} object that gives the
log-likelihood function for this dataset.  There is a player named
\dQuote{\code{possession}} that is a reified entity representing the
effect of possession.

Object \code{NBA_maxp} is not the result of running \code{maxp(NBA)}; it
was obtained by repeatedly running \code{maxp_simplex()} on a
fault-tolerant system [it triggers a known \R bug, bugzilla id 17703,
giving a \dQuote{\code{wmmin not finite}} error].  It is not clear to me
that likelihood function \code{NBA} has a well-defined global maximum.

Object \code{NBA} poses difficulty for the numerical optimization
routines for some reason.

Note that function \code{volley()} is not applicable because we need to
include possession.

These objects can be generated by running script
\code{inst/NBA.Rmd}, which includes some further discussion and
technical documentation and creates file \code{NBA.rda} which
resides in the \code{data/} directory.

}
\references{
  \url{https://www.espn.com/nba/playbyplay?gameId=400954514}
}
\seealso{\code{\link{volleyball}}}
\examples{

data(NBA)
dotchart(NBA_maxp)

}
\keyword{datasets}
