% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BLUE_estimates_QT.R
\name{BLUE_estimates_QT}
\alias{BLUE_estimates_QT}
\title{BLUE_estimates_QT function}
\usage{
BLUE_estimates_QT(
  discovery_pheno,
  discovery_geno_mat,
  target_pheno,
  target_geno_mat,
  significance_level = 0.05
)
}
\arguments{
\item{discovery_pheno}{Character. Path to the phenotype file for the discovery dataset. Assumes no header and that the quantitative trait is in the third column.}

\item{discovery_geno_mat}{Character. Path to the genotype matrix file for the discovery dataset. Assumes no header.}

\item{target_pheno}{Character. Path to the phenotype file for the target dataset. Assumes no header and individual IDs in the second column.}

\item{target_geno_mat}{Character. Path to the genotype matrix file for the target dataset. Assumes no header.}

\item{significance_level}{Numeric. Significance level for confidence intervals (e.g., 0.05 for 95\% CI). Default is 0.05.}
}
\value{
A data frame with the following columns:
\describe{
\item{IID}{Individual identifier (from the target phenotype file).}
\item{PRS}{Estimated polygenic risk score for each individual.}
\item{Variance}{Estimated variance of the PRS.}
\item{Lower_Limit}{Lower bound of the confidence interval.}
\item{Upper_Limit}{Upper bound of the confidence interval.}
}
}
\description{
Estimates individual-level polygenic risk scores (PRS) with uncertainty using a frequentist approach
for quantitative traits. This implementation fits a multiple linear regression model in the discovery dataset,
computes the coefficient covariance matrix, and applies the delta method to propagate uncertainty to the target dataset.
}
\details{
The function fits a multiple linear regression model (\code{lm}) using the discovery data. The estimated SNP effects
and their covariance matrix are used to compute PRS and associated uncertainty for each individual in the target dataset.
Confidence intervals are constructed using the normal approximation.

Missing or non-estimable coefficients and variances are set to zero.
}
\examples{
  qpd <- system.file("Qpd.txt", package = "iPRSue", mustWork = TRUE)
  qpt <- system.file("Qpt.txt", package = "iPRSue", mustWork = TRUE)
  gd  <- system.file("Gd.txt",  package = "iPRSue", mustWork = TRUE)
  gt  <- system.file("Gt.txt",  package = "iPRSue", mustWork = TRUE)
 
  results <- BLUE_estimates_QT(
    discovery_pheno    = qpd,
    discovery_geno_mat = gd,
    target_pheno       = qpt,
    target_geno_mat    = gt,
    significance_level = 0.05
  )
  head(results)

}
