% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_convert_filenames.R
\name{ifcb_convert_filenames}
\alias{ifcb_convert_filenames}
\title{Convert IFCB Filenames to Timestamps}
\usage{
ifcb_convert_filenames(filenames, tz = "UTC")
}
\arguments{
\item{filenames}{A character vector of IFCB filenames in the format "DYYYYMMDDTHHMMSS_IFCBxxx"
or "IFCBxxx_YYYY_DDD_HHMMSS". Filenames can optionally include an ROI number,
which will be extracted if present.}

\item{tz}{Character. Time zone to assign to the extracted timestamps.
Defaults to "UTC". Set this to a different time zone if needed.}
}
\value{
A tibble with the following columns:
\itemize{
\item \code{sample}: The extracted sample name (character).
\item \code{full_timestamp}: The full timestamp in "YYYY-MM-DD HH:MM:SS" format (POSIXct).
\item \code{year}: The year extracted from the timestamp (integer).
\item \code{month}: The month extracted from the timestamp (integer).
\item \code{day}: The day extracted from the timestamp (integer).
\item \code{time}: The extracted time in "HH:MM:SS" format (character).
\item \code{ifcb_number}: The IFCB instrument number (character).
\item \code{roi}: The extracted ROI number if available (integer or \code{NA}).
}

If the \code{roi} column is empty (all \code{NA}), it will be excluded from the output.
}
\description{
This function converts IFCB filenames to a data frame with separate columns for
the sample name, full timestamp, year, month, day, time, and IFCB number.
ROI numbers are included if available.
}
\examples{
filenames <- c("D20230314T001205_IFCB134", "D20230615T123045_IFCB135")
timestamps <- ifcb_convert_filenames(filenames)
print(timestamps)

}
