% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subjects.R
\name{ibge_subjects}
\alias{ibge_subjects}
\title{IBGE subject codes lookup}
\usage{
ibge_subjects(pattern = NULL, ignore_case = TRUE)
}
\arguments{
\item{pattern}{Optional character string. A regular expression used to
filter subject descriptions. If \code{NULL} (default), returns the full table.
Matching is case-insensitive by default.}

\item{ignore_case}{Logical. If \code{TRUE} (default), pattern matching ignores
case.}
}
\value{
A \link[tibble:tibble]{tibble} with columns:
\describe{
\item{id}{Integer subject code.}
\item{name}{Character subject description.}
}
}
\description{
Returns a tibble with IBGE subject (theme) codes and descriptions. These
codes can be used to understand the thematic organization of IBGE surveys
and aggregates.
}
\details{
The table is built-in (no API call is made) and contains all subject codes
currently defined by IBGE.
}
\examples{
# All subjects
ibge_subjects()

# Find sanitation-related themes
ibge_subjects("saneamento|esgoto|lixo")

# Find themes mentioning "internet"
ibge_subjects("internet")

}
