% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v0_vis.R
\name{vis}
\alias{vis}
\title{One function to visualise them all}
\usage{
vis(.data, ...)
}
\arguments{
\item{.data}{Pass the output from any immunarch analysis tool to \code{vis()}.}

\item{...}{Any other arguments, see the "Details" section for specific visualisation functions.}
}
\value{
A ggplot2, pheatmap or circlize object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Output from every function in immunarch can be visualised with a
single function - \code{vis}. The \code{vis} automatically detects
the type of the data and draws a proper visualisation. For example, output
from the \code{repOverlap} function will be identified as repertoire overlap values
and respective visualisation will be chosen without any additional arguments.
See "Details" for the list of available visualisations.
}
\details{
List of available visualisations for different kinds of data.

Basic analysis:
\itemize{
\item Exploratory analysis results (from \link{repExplore}) - see \link{vis.immunr_exp_vol};
\item Clonality statistics (from \link{repClonality}) - see \link{vis.immunr_homeo}.
}

Overlaps and public clonotypes:
\itemize{
\item Overlaps (from \link{repOverlap}) using heatmaps, circos plots, polar area plots - see \link{vis.immunr_ov_matrix};
\item Overlap clustering (from \link{repOverlapAnalysis}) - see \link{vis.immunr_hclust};
\item Repertoire incremental overlaps (from \link{repOverlap}) - see \link{vis.immunr_inc_overlap};
\item Public repertoire abundance (from \link{pubRep}) - vis \link{vis.immunr_public_repertoire}.
}

Gene usage:
\itemize{
\item Gene usage statistics (from \link{geneUsage}) using bar plots, box plots - see \link{vis.immunr_gene_usage};
\item Gene usage distances (from \link{geneUsageAnalysis}) using heatmaps, circos plots, polar area plots - see \link{vis.immunr_ov_matrix};
\item Gene usage clustering (from \link{geneUsageAnalysis}) - see \link{vis.immunr_hclust}.
}

Diversity estimation:
\itemize{
\item Diversity estimations (from \link{repDiversity}) - see \link{vis.immunr_chao1}.
}

BCR analysis:
\itemize{
\item Clonal tree (from \link{repClonalFamily}) - see \link{vis.clonal_family} and \link{vis.clonal_family_tree}.
}

Advanced analysis:
\itemize{
\item Repertoire dynamics (from \link{trackClonotypes}) - see \link{vis.immunr_dynamics};
\item Sequence logo plots of amino acid distributions (from \link{kmer_profile}) - see \link{vis_seqlogo};
\item Kmers distributions (from \link{getKmers}) - see \link{vis.immunr_kmer_table};
\item Mutation networks (from mutationNetwork) - Work In Progress on vis.immunr_mutation_network;
\item CDR3 amino acid properties, e.g., biophysical (from cdrProp) - Work In Progress on vis.immunr_cdr_prop.
}

Additionaly, we provide a wrapper functions for visualisations of common data types:
\itemize{
\item Any data frames or matrices using heatmaps - see \link{vis_heatmap} and \link{vis_heatmap2};
\item Any data frames or matrices using circos plots - see \link{vis_circos}.
}
}
\examples{
\dontrun{
# Load the test data
data(immdata)

# Compute and visualise:
ov <- repOverlap(immdata$data)
vis(ov)

gu <- geneUsage(immdata$data)
vis(gu)

dv <- repDiversity(immdata$data)
vis(dv)
}
}
\seealso{
\link{fixVis} for precise manipulation of plots.
}
