% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impermanent_loss.R
\name{impermanent_loss}
\alias{impermanent_loss}
\title{Impermanent Loss Calculator for Weighted AMM Pools}
\usage{
impermanent_loss(
  prices_old,
  prices_new,
  weights,
  investment,
  fees,
  plot = FALSE
)
}
\arguments{
\item{prices_old}{A numeric vector of initial prices for each asset.}

\item{prices_new}{A numeric vector of new prices for each asset.}

\item{weights}{A numeric vector of weights (must sum to 1) corresponding to the assets.}

\item{investment}{The initial total dollar value invested in the pool.}

\item{fees}{The total dollar value of trading fees earned by the LP during the period.}

\item{plot}{A logical value. If TRUE, generates a bar chart comparing the value if held,
value in the pool, and the net value (pool + fees).}
}
\value{
A list containing the core metrics:
\itemize{
\item \code{Value if held}: Total current value if assets were held outside the pool.
\item \code{Value in pool}: Total current value of the tokens in the pool.
\item \code{impermanent_loss_percent}: The IL as a percentage of the held portfolio value.
\item \code{Nominal impermanent loss}: The IL as a dollar-value opportunity loss.
\item \code{Fee offset ($)}: The total dollar fees earned.
\item \code{Net gain}: The LP's net PnL (Fees MINUS Nominal IL) relative to holding.
}
}
\description{
Calculates the Nominal Impermanent Loss (IL), Percentage IL, and Net Profit and Loss (PnL)
for a liquidity position in a weighted Automated Market Maker (AMM) pool.
This function is crucial for assessing the performance of liquidity provider positions
in protocols like Balancer and Uniswap.
}
\examples{
library(impermanentlosscalc)
library(ggplot2)
# Example 1: 3-Asset Unbalanced Pool (Weights: 30/20/50)
impermanent_loss(
prices_old = c(10, 20, 40),
prices_new = c(9, 22, 35),
weights = c(0.3, 0.2, 0.5),
investment = 1000,
fees = 10,
plot = TRUE
)


# Example 2: No price change, demonstrating IL is zero.
impermanent_loss(
  prices_old = c(3, 3),
  prices_new = c(3, 3),
  weights = c(0.5, 0.5),
  investment = 500,
  fees = 0
)
}
\references{
Tiruviluamala, N., Port, A., & Lewis, E. (2022). A general framework for impermanent loss in automated market makers. arXiv preprint arXiv:2203.11352.
}
