% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeSummaryStatisticsTable.R
\name{getStatisticsSummaryStatisticsTable}
\alias{getStatisticsSummaryStatisticsTable}
\title{Compute custom statistics specified by the user.}
\usage{
getStatisticsSummaryStatisticsTable(
  summaryTable,
  statsVarInit,
  var = NULL,
  stats = NULL,
  statsVarBy = NULL
)
}
\arguments{
\item{summaryTable}{Summary table.}

\item{statsVarInit}{Character vector with initial statistics names.}

\item{var}{Character vector with variable(s) of \code{data}, 
to compute statistics on.\cr
If NULL (by default), counts by row/column variable(s) are computed.\cr
To also return counts of the \code{rowVar} in case other \code{var}
are specified, you can include: 'all' in the \code{var}.\cr
Missing values, if present, are filtered 
(also for the report of number of subjects/records).}

\item{stats}{(Optionally) named list of expression or call object of summary statistics of interest.
The names are reported in the header.
The following variables are recognized, if the table is a: 
\itemize{
\item{'summaryTable': 
\itemize{
\item{'statN': number of subjects}
\item{'statMean': mean of \code{var}}
\item{'statSD': standard deviation of \code{var}}
\item{'statSE': standard error of \code{var}}
\item{'statMedian': median of \code{var}}
\item{'statMin': minimum of \code{var}}
\item{'statMax': maximum of \code{var}}
\item{'statPerc': percentage of subjects}
\item{'statm': number of records}
}
}
\item{'countTable': 
\itemize{
\item{'statN': number of subjects}
\item{'statPercN': percentage of subjects}
\item{'statm': number of records}
}
}
}
If \code{stats} if of length 1, the name of the summary statistic is not included
in the table.
The statistics can be specified for each \code{var} (if multiple), 
by naming each element of the list:
list(varName1 = list(...), varName2 = list()) and/or for each element in:
\code{statsVarBy}, by naming each sublist.}

\item{statsVarBy}{Character vector with colnames of
\code{data} by which the statistics should be computed.
In this case, \code{stats} (nested list or not) should be additionally nested
to specify the statistics for each element in \code{statsVarBy}.}
}
\value{
List with two elements:
\itemize{
\item{'summaryTable': summary table updated with statistics specified in \code{stats}}
\item{'statsVar': Character vector with statistics names}
}
}
\description{
Compute custom statistics specified by the user.
}
\author{
Laure Cougnaud
}
\keyword{internal}
