% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_covid_stats_by_country.R
\name{get_covid_stats_by_country}
\alias{get_covid_stats_by_country}
\title{Get COVID-19 Statistics for All Countries}
\usage{
get_covid_stats_by_country(
  yesterday = FALSE,
  twoDaysAgo = FALSE,
  sort = NULL,
  allowNull = FALSE
)
}
\arguments{
\item{yesterday}{Logical. If \code{TRUE}, retrieves data reported from the previous day. Default is \code{FALSE}.}

\item{twoDaysAgo}{Logical. If \code{TRUE}, retrieves data reported two days ago. Default is \code{FALSE}.}

\item{sort}{Character. Field to sort results by. Options include: \code{"cases"}, \code{"todayCases"}, \code{"deaths"}, \code{"recovered"}, \code{"active"}, etc.}

\item{allowNull}{Logical. If \code{TRUE}, missing values are returned as \code{NA} instead of \code{0}. Default is \code{FALSE}.}
}
\value{
A data frame containing:
\itemize{
  \item \code{country}: Country name.
  \item \code{updated}: Last updated timestamp (as POSIXct in UTC).
  \item \code{cases}: Total confirmed cases.
  \item \code{todayCases}: New confirmed cases today.
  \item \code{deaths}: Total deaths.
  \item \code{todayDeaths}: New deaths today.
  \item \code{population}: Population estimate for each country.
}
Returns \code{NULL} if the API is unavailable or an error occurs.
}
\description{
Retrieves real-time COVID-19 totals for all countries from the 'disease.sh' API.
}
\details{
This function fetches COVID-19 summary statistics for each country.
Useful for global surveillance or international comparisons.
Requires an active internet connection.
}
\note{
Requires internet access. Function fails gracefully if API is unavailable.
}
\examples{
\dontrun{
# Get real-time COVID-19 data for all countries
all_countries <- get_covid_stats_by_country()
if (!is.null(all_countries)) {
  head(all_countries)
}

# Get sorted data by number of deaths reported yesterday
yesterday_deaths <- get_covid_stats_by_country(yesterday = TRUE, sort = "deaths")
}

}
\references{
API Docs: https://disease.sh/docs/#/COVID-19%3A%20Worldometers/get_v3_covid_19_countries
}
