% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interfacer.R
\name{ivalidate}
\alias{ivalidate}
\title{Perform interface checks on dataframe inputs using enclosing function formal
parameter definitions}
\usage{
ivalidate(df = NULL, ..., .imap = imapper(), .prune = FALSE, .default = NULL)
}
\arguments{
\item{df}{a dataframe - if missing then the first parameter of the calling
function is assumed to be a dataframe.}

\item{...}{not used but \code{ivalidate} should be included in call to inherit
\code{.imap} from the caller function.}

\item{.imap}{a set of mappings as an \code{imapper} object.}

\item{.prune}{get rid of excess columns that are not in the spec.}

\item{.default}{a default dataframe conforming to the specification. This
overrides any defaults defined in the interface specification}
}
\value{
a dataframe based on \code{df} with validity checks passed and \code{.imap}
mappings applied if present
}
\description{
\code{ivalidate(...)} is intended to be used within a function to check the validity of a data
frame parameter (usually the first parameter) against an \code{ispec} which is
given as a default value of a formal parameter.
}
\examples{
x = function(df = iface(col1 = integer ~ "an integer column" ), ...) {
  df = ivalidate(...)
  return(df)
}
input=tibble::tibble(col1 = c(1,2,3))
x(input)

# This fails because col1 is not coercable to integer
input2=tibble::tibble(col1 = c(1.5,2,3))
try(x(input2))
}
\concept{interface}
