% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-croatia_2010_1700.R
\docType{data}
\name{croatia_2010_1700}
\alias{croatia_2010_1700}
\title{Input-output table for Croatia, 2010}
\format{
A data frame with 13 variables:
\describe{
\item{t_rows2}{Technology codes in row names, following Eurostat
conventions.}
\item{t_rows2_lab}{Longer labels for \code{t_rows2}.}
\item{t_cols2}{Technology codes in column names, following Eurostat
conventions.}
\item{t_cols2_lab}{Longer labels for \code{t_cols2}.}
\item{iotables_col}{Standardized column labels for easier reading.}
\item{col_order}{Ordering index to keep the matrix legible.}
\item{row_order}{Ordering index to keep the matrix legible.}
\item{iotables_row}{Standardized row labels for easier reading.}
\item{unit}{Unit of measure. Here: thousand national currency units
(kunas).}
\item{geo}{ISO/Eurostat country code for Croatia.}
\item{geo_lab}{ISO/Eurostat country name, "Croatia".}
\item{time}{Date of the SIOT.}
\item{values}{Observed values in thousand kunas.}
}
}
\source{
\href{https://dzs.gov.hr/}{Državni zavod za statistiku}
}
\usage{
croatia_2010_1700
}
\description{
Symmetric input-output table at basic prices (product × product).
Original code: \strong{1700}.
Values are expressed in thousand kunas (\code{T_NAC}).
}
\seealso{
Other Croatia 2010 datasets: 
\code{\link{croatia_2010_1800}},
\code{\link{croatia_2010_1900}},
\code{\link{croatia_employment_2013}},
\code{\link{croatia_employment_aggregation}},
\code{\link{primary_inputs}}
}
\concept{Croatia 2010 datasets}
\keyword{datasets}
