% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiplier_create.R
\name{multiplier_create}
\alias{multiplier_create}
\title{Create multipliers}
\usage{
multiplier_create(
  input_vector,
  Im,
  multiplier_name = "multiplier",
  digits = NULL
)
}
\arguments{
\item{input_vector}{A named numeric vector (or 1-column matrix)
created by \code{\link[=input_indicator_create]{input_indicator_create()}} whose names match the ordering
of the Leontief inverse columns.}

\item{Im}{A Leontief inverse matrix created by
\code{\link[=leontief_inverse_create]{leontief_inverse_create()}}. Column names must correspond to products
or industries consistent with \code{input_vector}.}

\item{multiplier_name}{A string used for the key column that labels the
returned multipliers. Default is \code{"multiplier"}.}

\item{digits}{Optional integer. If supplied and non-negative, round the
resulting multipliers to this number of decimal places. Negative
values are ignored (no rounding).}
}
\value{
A data frame with:
\itemize{
\item a first key column (character) named as the first column of
\code{input_vector} and filled with \code{multiplier_name}, and
\item one numeric column per product/industry containing the multipliers.
}
}
\description{
Wrapper around \code{\link[=equation_solve]{equation_solve()}} that computes total multipliers by
post-multiplying an input indicator vector with a Leontief inverse and
adds a key column carrying the multiplier name for consistent joins.
}
\details{
In the Eurostat IO framework, multipliers measure \emph{total} effects per
unit of \strong{final demand}, by product or industry (via the Leontief
inverse \eqn{(I - A)^{-1}}). This contrasts with \emph{direct effects},
which reflect only the immediate (first-round) impact.

The function delegates the numerical solve to \code{\link[=equation_solve]{equation_solve()}} and
then formats the result for tidy joining with other IO tables. Ensure
that the dimension ordering and names of \code{input_vector} and \code{Im}
correspond; otherwise results will be misaligned.
}
\examples{
# Minimal workflow -----------------------------------------------
data_table <- iotable_get()

coeff_de <- input_coefficient_matrix_create(data_table)

de_gva_indicator <- input_indicator_create(
  data_table = data_table,
  input = "gva"
)

I_de <- leontief_inverse_create(coeff_de)

de_gva_multipliers <- multiplier_create(
  input_vector = de_gva_indicator,
  Im = I_de,
  multiplier_name = "employment_multiplier",
  digits = 4
)

}
\seealso{
\code{\link[=equation_solve]{equation_solve()}}, \code{\link[=input_indicator_create]{input_indicator_create()}},
\code{\link[=leontief_inverse_create]{leontief_inverse_create()}}

Other multiplier functions: 
\code{\link{input_multipliers_create}()},
\code{\link{output_multiplier_create}()}
}
\concept{multiplier functions}
