% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isoaxes.R
\name{isoaxesGrob}
\alias{isoaxesGrob}
\title{Create a grob representing the specified axis orientation.}
\usage{
isoaxesGrob(
  size = 5,
  x = 0.5,
  y = 0.5,
  default.units = "mm",
  xyplane = "flat",
  handedness = "right",
  labels = TRUE,
  verbosity = 0,
  ...
)
}
\arguments{
\item{size}{length of each axis  in \code{default.units}}

\item{x, y}{the origin of the isometric coordinate system.
If these values are given as vanilla floating point values, they 
will be interpreted as 'npc' units, otherwise a valid grid unit 
object must be supplied.
By default the origin is the middle of the graphics device 
i.e. \code{(x, y) = (0.5, 0.5)}}

\item{default.units}{Default unit for size of a cube is 'mm'}

\item{xyplane}{How is the xyplane oriented with respect to the unit isometric
cube?.  "left", "right", "flat" (or "top").
Default: "flat".}

\item{handedness}{How is the z-axis positioned with respect to the xy-plane?
I.e. is this a right-handed or left-handed coordinate system?
Default: "right"}

\item{labels}{Include axis labels? Default: TRUE}

\item{verbosity}{Verbosity level. Default: 0}

\item{...}{other values passed to \code{gpar()} to set the graphical
parameters e.g. \code{lwd} and \code{col} for the linewidth and colour
of the outline stroke for each cube face.}
}
\value{
grid \code{grob} object
}
\description{
The x, y and z axes are drawn in red, green and blue respectively.
}
\examples{
isoaxesGrob() |> 
  grid::grid.draw()
}
