% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.R
\name{wald_gam}
\alias{wald_gam}
\title{Function for post-hoc comparison of the contrasts in a single GAMM model.}
\usage{
wald_gam(
  model,
  comp = NULL,
  select = NULL,
  t.test = FALSE,
  null.hypothesis = 0,
  summ = NULL,
  signif.stars = TRUE,
  print.output = getOption("itsadug_print")
)
}
\arguments{
\item{model}{Model, currently only implemented for models generated with 
\code{\link[mgcv]{bam}} or \code{\link[mgcv]{gam}}.}

\item{comp}{Named list with predictors (specified as names) and their levels
 to compare. Defaults to NULL, which returns all comparisons, 
unless \code{select} is specified.}

\item{select}{Contrast matrix for manually specified contrasts. 
Alternatively, a vector or list could be provided as input. 
See examples below.}

\item{t.test}{Logical default = FALSE), whether or not to return 
the t-test scores instead of the Wald test. Only implemented for 
Gaussian models.  This option is not implemented for use with \code{select}.}

\item{null.hypothesis}{Numeric, value of null hypothesis. Defaults to 0 and 
is generally not changed.}

\item{summ}{Optional summary object. Defaults to NULL. For very large GAMM 
models it takes a long time to retrieve the summary. In these cases the 
summary could be provided to reduce processing time. 
However, it is generally recommended not to specifify a summary object, 
to reduce the chance of mismatch errors.}

\item{signif.stars}{Logical (default = TRUE). Whether or not to display 
stars indicating the level of significance on 95\% confidence level.}

\item{print.output}{Logical: whether or not to print the output. 
By default controlled globally in the package options:  
If the function \code{\link{infoMessages}} is set to TRUE, the output 
will be automatically printed.
Could be also set by explicitly providing TRUE or FALSE. See examples.}
}
\value{
Optionally returns a data frame with test statistics.
}
\description{
Function for post-hoc comparison of the intercept differences 
for different factors in a single GAMM model.
}
\section{Warning}{

This function is intended for testing intercept differences only.
This function compares purely the parametric components, without 
considering any interactions with smooth terms. So this could be 
considered as a partial effect comparison. For comparing the averages 
of conditions use \code{\link{get_difference}}, which outputs the 
difference in summed effects for different factor levels.
}

\examples{
data(simdat)
# Convert Condition to factorial predictor for illustration purposes:
simdat$Condition <- as.factor(simdat$Condition)

infoMessages('on')

\dontrun{
# some arbitrary model:
m1 <- bam(Y ~ Condition*Group  
\t+ s(Time, by=Condition) 
\t+ s(Time, by=Group)
\t+ s(Subject, bs='re'), 
\tdata=simdat)

# print summary to inspect parametric terms:
summary(m1)

# return all contrasts:
wald_gam(m1)

# USE OF COMP
# return only contrasts for Adults:
wald_gam(m1, comp=list(Condition=levels(simdat$Condition)))
# return specific contrasts:
wald_gam(m1, comp=list(Condition=c('-1', '0', '1'), 
    Group=c('Adults', 'Children')))

# USE OF SELECT
# Specify contrast matrix. 
# Note that intercept should be 0.
# Example: Compare Condition 0 with Conditions 2 and 3 for children.
# Method 1: matrix or vector:
R = matrix( c(0,-2,0,1,1,0,0,0,0,0,0,0), nrow=1)
wald_gam(m1, select=R) 
wald_gam(m1, select=c(0,-2,0,1,1,0,0,0,0,0,0,0)) 
# Method 2: list
# first list element are reference coefficients, 
# second list element are coefficients to compare
wald_gam(m1, select=list(2, c(4,5))) 
# Replication of contrasts given in summary:
wald_gam(m1, select=c(0,1,0,0,0,0,0,0,0,0,0,0))

# USE OF T.TEST
# This option is not implemented for use with select
# Compare with second line of parametric summary:
wald_gam(m1, comp=list(Condition=c('-1', '0'), 
    Group='Children'), t.test=TRUE)
# Compare with Wald test:
wald_gam(m1, comp=list(Condition=c('-1', '0'), 
    Group='Children'))

# exclude significance stars:
wald_gam(m1, comp=list(Condition=c('-1', '0'), 
    Group='Children'), signif.stars=FALSE)

# do not print output, but save table for later use:
test <- wald_gam(m1, comp=list(Condition=c('-1', '0'), 
    Group='Children'), print.output=FALSE)
test
# alternative way:
infoMessages('off')
test2 <- wald_gam(m1, comp=list(Condition=c('-1', '0'), 
    Group='Children'))
infoMessages('on')

}
}
\seealso{
\code{\link{plot_parametric}}, \code{\link{plot_diff}}, 
\code{\link{plot_diff2}}

Other Testing for significance: 
\code{\link{compareML}()},
\code{\link{plot_diff}()},
\code{\link{plot_diff2}()},
\code{\link{report_stats}()}
}
\author{
Petar Milin and Jacolien van Rij.
}
\concept{Testing for significance}
