% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/digit_test.R
\name{digit_test}
\alias{digit_test}
\title{Data Auditing: Digit Distribution Test}
\usage{
digit_test(
  x,
  check = c("first", "last", "firsttwo", "lasttwo"),
  reference = "benford",
  conf.level = 0.95,
  prior = FALSE
)
}
\arguments{
\item{x}{a numeric vector.}

\item{check}{location of the digits to analyze. Can be \code{first},
\code{last}, \code{firsttwo}, or \code{lasttwo}.}

\item{reference}{which character string given the reference distribution for
the digits, or a vector of probabilities for each digit. Can be
\code{benford} for Benford's law, \code{uniform} for the uniform
distribution. An error is given if any entry of \code{reference} is
negative. Probabilities that do not sum to one are normalized.}

\item{conf.level}{a numeric value between 0 and 1 specifying the
confidence level (i.e., 1 - audit risk / detection risk).}

\item{prior}{a logical specifying whether to use a prior distribution,
or a numeric value equal to or larger than 1 specifying the prior
concentration parameter, or a numeric vector containing the prior
parameters for the Dirichlet distribution on the digit categories.}
}
\value{
An object of class \code{jfaDistr} containing:

\item{data}{the specified data.}
\item{conf.level}{a numeric value between 0 and 1 giving the confidence
  level.}
\item{observed}{the observed counts.}
\item{expected}{the expected counts under the null hypothesis.}
\item{n}{the number of observations in \code{x}.}
\item{statistic}{the value the chi-squared test statistic.}
\item{parameter}{the degrees of freedom of the approximate chi-squared
  distribution of the test statistic.}
\item{p.value}{the p-value for the test.}
\item{check}{checked digits.}
\item{digits}{vector of digits.}
\item{reference}{reference distribution}
\item{match}{a list containing the row numbers corresponding to the
  observations matching each digit.}
\item{deviation}{a vector indicating which digits deviate from their
  expected relative frequency under the reference distribution.}
\item{prior}{a logical indicating whether a prior distribution was used.}
\item{data.name}{a character string giving the name(s) of the data.}
}
\description{
This function extracts and performs a test of the distribution
of (leading) digits in a vector against a reference distribution. By default,
the distribution of leading digits is checked against Benford's law.
}
\details{
Benford's law is defined as \eqn{p(d) = log10(1/d)}. The uniform
  distribution is defined as \eqn{p(d) = 1/d}.
}
\examples{
set.seed(1)
x <- rnorm(100)

# First digit analysis against Benford's law
digit_test(x, check = "first", reference = "benford")

# Bayesian first digit analysis against Benford's law
digit_test(x, check = "first", reference = "benford", prior = TRUE)

# Last digit analysis against the uniform distribution
digit_test(x, check = "last", reference = "uniform")

# Bayesian last digit analysis against the uniform distribution
digit_test(x, check = "last", reference = "uniform", prior = TRUE)

# First digit analysis against a custom distribution
digit_test(x, check = "last", reference = 1:9)

# Bayesian first digit analysis against a custom distribution
digit_test(x, check = "last", reference = 1:9, prior = TRUE)
}
\references{
Benford, F. (1938). The law of anomalous numbers.
  \emph{In Proceedings of the American Philosophical Society}, 551-572.

Preece, D. A. (1981). Distributions of final digits in data.
  \emph{Journal of the Royal Statistical Society Series D: The Statistician},
  30(1), 31-60. \doi{10.2307/2987702}

Dlugosz, S., & Müller-Funk, U. (2009). The value of the last
  digit: Statistical fraud detection with digit analysis.
  \emph{Advances in data analysis and classification}, 3(3), 281-290.
  \doi{10.1007/s11634-009-0048-5}
}
\seealso{
\code{\link{repeated_test}}
}
\author{
Koen Derks, \email{k.derks@nyenrode.nl}
}
\keyword{Bayesian}
\keyword{Benford}
\keyword{audit}
\keyword{digits}
\keyword{distribution}
