% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jmSurface-package.R
\docType{package}
\name{jmSurface-package}
\alias{jmSurface}
\alias{jmSurface-package}
\title{jmSurface: Semi-Parametric Association Surfaces for Joint Models}
\description{
The \pkg{jmSurface} package implements interpretable multi-biomarker fusion
in joint longitudinal-survival models via semi-parametric association surfaces
for multi-state disease processes.
}
\section{Main functions}{

\describe{
\item{\code{\link{jmSurf}}}{Fit the two-stage joint model}
\item{\code{\link{fit_longitudinal}}}{Stage 1: fit longitudinal submodels}
\item{\code{\link{fit_gam_cox}}}{Stage 2: fit GAM-Cox with tensor-product surface}
\item{\code{\link{edf_diagnostics}}}{Extract EDF and complexity diagnostics}
\item{\code{\link{dynPred}}}{Dynamic prediction of transition probabilities}
\item{\code{\link{plot_surface}}}{3D association surface visualization}
\item{\code{\link{contour_heatmap}}}{Contour heatmap of danger zones}
\item{\code{\link{marginal_slices}}}{Marginal effect slice plots}
\item{\code{\link{simulate_jmSurface}}}{Simulate multi-state data}
\item{\code{\link{run_shiny_app}}}{Launch interactive Shiny dashboard}
}
}

\references{
Bhattacharjee, A. (2025). Interpretable Multi-Biomarker Fusion in Joint
Longitudinal-Survival Models via Semi-Parametric Association Surfaces.
}
\author{
\strong{Maintainer}: Atanu Bhattacharjee \email{atanustat@gmail.com} (\href{https://orcid.org/0000-0002-5757-5513}{ORCID})

}
