% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_magnitude.R
\name{set_magnitude}
\alias{set_magnitude}
\title{Define magnitude, magnitude label and denominator for a vector of numeric values}
\usage{
set_magnitude(
  x,
  metric,
  mag = NULL,
  count_label_thousands = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{x}{[num] numeric vector}

\item{metric}{[chr] metric: "prop", "pp", "count", "rate" (required)}

\item{mag}{[chr: default NULL] magnitude override (NULL = auto-detect)
- For counts: "t", "m", "b"
- For rates: "per10", "per100", "per1k", ..., "per10b"
- For props/pp: "as-is" (no scaling, use values as provided)}

\item{count_label_thousands}{[lgl: default FALSE] allow "thousands" magnitude for counts?
Not Lancet-valid.}

\item{verbose}{[lgl: default TRUE] show warnings?}
}
\value{
[data.frame] with columns: mag, mag_label, denom
}
\description{
Support function used on _central_ (e.g. mean) values for later formatting.
Routes to appropriate helper based on metric.
}
\examples{
# Proportions (no scaling)
set_magnitude(c(0.5, 0.75), metric = "prop")

# Counts
set_magnitude(c(1e3, 1e6, 1e9), metric = "count")

# Rates
set_magnitude(c(0.0000123, 0.0000456), metric = "rate")
}
\seealso{
Other magnitudes: 
\code{\link{fmt_magnitude}()},
\code{\link{set_magnitude_count}()},
\code{\link{set_magnitude_prop}()},
\code{\link{set_magnitude_rate}()}
}
\concept{magnitudes}
