% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VisualizationFunctions.R
\name{static_plot}
\alias{static_plot}
\title{Plot fixations in 2D space on a stimulus image (with visible x and y axis labels and ticks)}
\usage{
static_plot(
  gazedata,
  xres = 1920,
  yres = 1080,
  plot.onset,
  plot.offset,
  background.images = NA,
  show.legend = TRUE,
  group.by = NA,
  gazepoint.size = 4,
  id_color_map = NA,
  connect.lines = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{gazedata}{Data frame with fixation data which must include columns for x and y coordinates as well as the
variable onset which indicates the onset of the fixation. If the categorical or factor variable id is included, separate colors will represent each participant. Make sure the onset variables match the timing  the plot.onset and plot.offset input.}

\item{xres}{horizontal resolution of the screen or area to plot on. Default 1920}

\item{yres}{vertical resolution of the screen or area to plot on. Default 1080}

\item{plot.onset}{Onset of the interval in the gaze_data$onset variable to plot in the same unit, typically milliseconds}

\item{plot.offset}{Offset of the interval in the gaze_data$onset variable to plot in the same unit, typically milliseconds}

\item{background.images}{data frame with background images to use as background. The data frame must include the variables min.x, min.y, max.x, and max.y variables representing
where the images should be placed on the background and the variable path specifying a full file path.
#Example:
\code{background.images <- data.frame(
       path = "my_image.jpg",
       min.x = 1,
       min.y = 1,
       max.x = 200.
       max.y = 200)}}

\item{show.legend}{If TRUE, show values in "id" in legend}

\item{group.by}{If not NA, plot each level in the variable in a separate panel. For example group.by \code{=} "group" returns a separate panel for each group and group.by \code{=}"id"
returns a separate panel for each id.}

\item{gazepoint.size}{Size of the circle illustrating the point of gaze}

\item{id_color_map}{A ggplot color map specifying a color to plot for each id. ids should match the variable id in the gazedata matrix. Set to NA to assign values automatically.
For example, the code cm <- setNames("darkblue", ""example.id") creates the color map cm which will plot all data points in gazedata where the variable id == "example.id" in dark blue}

\item{connect.lines}{If TRUE, gaze coordinates are connected with lines}

\item{verbose}{If TRUE, the resulting figure is displayed automatically}
}
\value{
a ggplot of raw and fixated values plotted on the y axis and sample number on the x axis
}
\description{
This function plots and returns a ggplot2 figure showing fixations on a background with one or multiple images, typically the stimuli. Data can
represent one or multiple participants. If you want a plot without visible axis labels and ticks, use static_plot_minimal
The interval to plot is defined by sample numbers. Fixations must have the variables x, y, and onset. The function is tested with .jpg-images. If paths to multiple images
are given, all will be displayed. Fixations are shown on a white background if no background images are defined
}
