% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{lcv_kdens_symmat}
\alias{lcv_kdens_symmat}
\title{Likelihood cross-validation for symmetric positive definite matrix kernels}
\usage{
lcv_kdens_symmat(x, b, kernel = "Wishart")
}
\arguments{
\item{x}{array of dimension \code{d} by \code{d} by \code{n}}

\item{b}{vector of candidate bandwidth, strictly positive}

\item{kernel}{string indicating the kernel, one of \code{Wishart} or \code{smlnorm}.}
}
\value{
a list with arguments
\itemize{
\item \code{lcv} vector of likelihood cross validation criterion
\item \code{b} vector of candidate bandwidth
\item \code{bandwidth} optimal bandwidth among candidates
\item \code{kernel} string indicating the choice of kernel function
}
}
\description{
Given a cube of sample observations (consisting of random symmetric positive definite matrices), and a vector of candidate bandwidth parameters \code{b},
compute the leave-one-out likelihood cross-validation criterion and
return the bandwidth among the choices that minimizes the criterion.
}
