% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llm_image_recognition.R
\name{llm_image_recognition}
\alias{llm_image_recognition}
\title{Image Recognition using LLMs}
\usage{
llm_image_recognition(
  llm_model = "qwen2.5vl",
  image = system.file("img/test_img.jpg", package = "kuzco"),
  recognize_object = "face",
  backend = "ellmer",
  additional_prompt = "",
  provider = "ollama",
  language = "English",
  ...
)
}
\arguments{
\item{llm_model}{a local LLM model either pulled from ollama or hosted}

\item{image}{a local image path that has a jpeg, jpg, or png}

\item{recognize_object}{an item you want to LLM to look for}

\item{backend}{either 'ollamar' or 'ellmer', note that 'ollamar' suggests structured outputs while 'ellmer' enforces structured outputs}

\item{additional_prompt}{text to append to the image prompt}

\item{provider}{for \code{backend = 'ollamar'}, \code{provider} is ignored. for \code{backend = 'ellmer'},
\code{provider} refers to the \verb{ellmer::chat_*} providers and can be used to switch
from "ollama" to other providers such as "perplexity"}

\item{language}{a language to guide the LLM model outputs}

\item{...}{a pass through for other generate args and model args like temperature. set the temperature to 0 for more deterministic output}
}
\value{
a df with object_recognized, object_count, object_description, object_location
}
\description{
Image Recognition using LLMs
}
\examples{
\donttest{
llm_image_recognition(
 llm_model = "qwen2.5vl",
 image = system.file("img/test_img.jpg", package = "kuzco"),
	recognize_object = "nose",
 backend = 'ellmer',
 additional_prompt = "",
provider = "ollama",
language = "English"
)
}
}
