% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/continuous.R
\name{fit_short_glm}
\alias{fit_short_glm}
\title{Fit GLM with Kernel Weights (Short-Term Event Info)}
\usage{
fit_short_glm(landpred_obj, t0, tau, t_s, bw, transform, indices = NULL)
}
\arguments{
\item{landpred_obj}{A landpred object containing the data.}

\item{t0}{The landmark time.}

\item{tau}{The prediction window.}

\item{t_s}{The time of the short-term event.}

\item{bw}{The bandwidth for kernel weighting.}

\item{transform}{A transformation function for the time variable (e.g., log).}

\item{indices}{Optional indices to subset the data.}
}
\value{
A fitted glm object.

}
\description{
Fits a GLM for the probability of the event occurring before \code{t0 + tau},
given survival up to \code{t0} and information on a short-term event.
Uses kernel weighting based on the short-term event time.
}
\keyword{internal}
