% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazysf.R
\name{lazysf}
\alias{lazysf}
\alias{lazysf.character}
\alias{lazysf.SFSQLConnection}
\title{Delayed (lazy) read for GDAL vector}
\usage{
lazysf(x, layer, ...)

\method{lazysf}{character}(x, layer, ..., query = NA)

\method{lazysf}{SFSQLConnection}(x, layer, ..., query = NA)
}
\arguments{
\item{x}{the data source name (file path, url, or database connection string
\itemize{
\item analogous to \code{\link[sf:st_read]{sf::read_sf()}} 'dsn')
}}

\item{layer}{layer name (varies by driver, may be a file name without
extension); in case \code{layer} is missing, \code{st_read} will read the
first layer of \code{dsn}, give a warning and (unless \code{quiet = TRUE})
print a message when there are multiple layers, or give an error if there
are no layers in \code{dsn}. If \code{dsn} is a database connection, then
\code{layer} can be a table name or a database identifier (see
\code{\link[DBI]{Id}}). It is also possible to omit \code{layer} and rather
use the \code{query} argument.}

\item{...}{ignored}

\item{query}{SQL query to pass in directly}
}
\value{
a 'tbl_SFSQLConnection', extending 'tbl_lazy' (something that works
with dplyr verbs, and only shows a preview until you commit the result via
\code{\link[=collect]{collect()}}) see Details
}
\description{
A lazy data frame for GDAL drawings ('vector data sources'). lazysf is DBI
compatible and designed to work with dplyr. It should work with any data source
(file, url, connection string) readable by the sf package function \code{sf_read}.
}
\details{
Lazy means that the usual behaviour of reading the entirety of a data source
into memory is avoided. Printing the output results in a preview query being
run and displayed (the top few rows of data).

The output of \code{lazysf()} is a 'tbl_SFSQLConnection\verb{that extends}tbl_dbi` and
may be used with functions and workflows in the normal DBI way, see \code{\link[=SFSQL]{SFSQL()}} for
the lazysf DBI support.

The kind of q uery that may be run will depend on the type of format, see the
list on the GDAL vector drivers page. For some details see the
\href{https://hypertidy.github.io/lazysf/articles/GDALSQL.html}{GDALSQL vignette}.

When dplyr is attached the lazy data frame can be used with the usual verbs
verbs (filter, select, distinct, mutate, transmute, arrange, left_join, pull,
collect etc.). To see the result as a SQL query rather than a data frame
preview use \code{dplyr::show_query()}.

To obtain an in memory data frame use an explict \code{collect()} or \code{st_as_sf()}.
A call to \code{collect()} is triggered by \code{st_as_sf()} and will add the sf class
to the output. A result may not contain a geometry column, and so cannot be
convert to an sf data frame. Using \code{collect()} on its own returns an
unclassed data.frame and may include a classed \code{sfc} geometry column.

As well as \code{collect()} it's also possible to use \code{tibble::as_tibble()} or
\code{as.data.frame()} or \code{pull()} which all force computation and retrieve the
result.
}
\examples{
# online sources can work
geojson <- file.path("https://raw.githubusercontent.com/SymbolixAU",
                     "geojsonsf/master/inst/examples/geo_melbourne.geojson")
\donttest{
lazysf(geojson)
}

## normal file stuff
## (Geopackage is an actual database so with SELECT we must be explicit re geom-column)
f <- system.file("gpkg/nc.gpkg", package = "sf", mustWork = TRUE)
lazysf(f)
lazysf(f, query = "SELECT AREA, FIPS, geom FROM \"nc.gpkg\" WHERE AREA < 0.1")
lazysf(f, layer = "nc.gpkg") \%>\% dplyr::select(AREA, FIPS, geom) \%>\% dplyr::filter(AREA < 0.1)

## the famous ESRI Shapefile (not an actual database)
## so if we SELECT we must be ex
shp <- lazysf(system.file("shape/nc.shp", package = "sf", mustWork = TRUE))
library(dplyr)
shp \%>\%
 filter(NAME \%LIKE\% 'A\%') \%>\%
 mutate(abc = 1.3) \%>\%
 select(abc, NAME, `_ogr_geometry_`) \%>\%
 arrange(desc(NAME))  #\%>\% show_query()

 ## a multi-layer file
 system.file("extdata/multi.gpkg", package = "lazysf", mustWork = TRUE)
}
