% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-class.R
\name{simulate_lba}
\alias{simulate_lba}
\alias{simulate,lba-method}
\alias{simulate}
\alias{simulate-lba}
\title{Simulate Data from an LBA Model}
\usage{
\S4method{simulate}{lba}(
  object,
  nsim = 4L,
  seed = NULL,
  n_subject = 3L,
  parameter_vector = NULL,
  use_inverse_method = FALSE,
  debug = FALSE
)
}
\arguments{
\item{object}{An object of class \code{lba} that defines the model
structure and parameters.}

\item{nsim}{Integer. Number of trials to simulate per subject. Defaults
to \code{4}.}

\item{seed}{Optional integer. Sets the random seed for reproducibility.
Defaults to \code{NULL}.}

\item{n_subject}{Integer. Number of subjects to simulate. Defaults to
\code{3}.}

\item{parameter_vector}{A named vector or list of parameters (e.g., \code{A},
\code{b}, \code{mean_v.true}, \code{t0}). Supply either
\code{parameter_vector} here or a population distribution via \code{setLBA}
(typically built with \code{ggdmcPrior::BuildPrior}). Defaults to
\code{NULL}.}

\item{use_inverse_method}{Logical. If \code{TRUE}, use inverse transform
sampling; otherwise use the process model to sample. Defaults to
\code{FALSE}.}

\item{debug}{Logical. If \code{TRUE}, print debugging output during
simulation. Defaults to \code{FALSE}.}
}
\value{
A data frame with:
\itemize{
\item \code{s} (lowercase): subject identifiers (factor)
\item \code{R} (uppercase): choices (integer/character)
\item \code{RT}: response times (numeric)
}
Plus user-defined condition columns derived from the model
}
\description{
Simulate response times and choices from a Linear Ballistic Accumulation
(LBA) model with a model specification (typically from
\code{ggdmcModel::BuildModel}).
}
\details{
This method simulates data from a design-based LBA model. You
can simulate multiple subjects, override default parameters,
and choose between standard and inverse sampling methods.
Turn on debugging mode by entering \code{TRUE} to the
option, \code{debug}.
}
\section{Notes}{

The internal mechanism is case sensitive. The choice of
using upper- or lowercase letters to denote variables is
a convention (originated from \code{DMC}), rather than a strict
requirement.
}

\examples{
if (requireNamespace("ggdmcModel", quietly = TRUE)) {
  BuildModel <- getFromNamespace("BuildModel", "ggdmcModel")

  model <- BuildModel(
    p_map = list(
      A = "1", B = "1", t0 = "1", mean_v = "M", sd_v = "1",
      st0 = "1"
    ),
    match_map = list(M = list("s1" = "r1", "s2" = "r2")),
    factors = list(S = c("s1", "s2")),
    constants = c(sd_v = 1, st0 = 0),
    accumulators = c("r1", "r2"),
    type = "lba"
  )
}
p_vector <- c(
  A = .75, B = 1.25, mean_v.false = 1.5, mean_v.true = 2.5,
  t0 = 0.15
)
sub_model <- setLBA(model)
sim_dat <- simulate(sub_model,
  nsim = 256, parameter_vector = p_vector,
  n_subject = 1
)
head(sim_dat)

}
\seealso{
\code{\link{simulate_lba_trials}} (low-level C++ back end),
\code{\link{theoretical_dlba}}, \code{\link{plba}}, \code{\link{dlba}}

Other LBA simulation: 
\code{\link{validate_lba_parameters}()}
}
\concept{LBA simulation}
