% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleParameters.R
\name{sampleParameters}
\alias{sampleParameters}
\title{Sample models parameters}
\usage{
sampleParameters(x, cholesky = FALSE)
}
\arguments{
\item{x}{an object of class \code{hlme}, \code{lcmm}, \code{multlcmm},
\code{Jointlcmm}, or \code{mpjlcmm}.}

\item{cholesky}{optional logical indicating if cholesky parameters should be
returned. Default to FALSE, the variance-covariance parameters of the
random effects are returned.}
}
\value{
a named vector containing the sampled parameters.
}
\description{
Generates parameters from models estimated with \code{hlme},
\code{lcmm}, \code{multlcmm}, \code{Jointlcmm} or \code{mpjlcmm} functions.
Parameters are randomly sampled from a Gaussian distribution using estimates
and corresponding variances of a model.
}
\examples{
m <- hlme(Y ~ Time * X1, random = ~ Time, subject = 'ID', data = data_hlme)

sampleParameters(m)

}
\author{
Viviane Philipps
}
