% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixcreation.R
\name{fleslie}
\alias{fleslie}
\title{Create Function-based Age-based (Leslie) Matrix Projection Model}
\usage{
fleslie(
  year = "all",
  patch = NULL,
  prebreeding = TRUE,
  data = NULL,
  modelsuite = NULL,
  surv_model = NULL,
  fec_model = NULL,
  paramnames = NULL,
  supplement = NULL,
  start_age = NA,
  last_age = NA,
  fecage_min = NA,
  fecage_max = NA,
  continue = TRUE,
  inda = NULL,
  indb = NULL,
  indc = NULL,
  annua = NULL,
  annub = NULL,
  annuc = NULL,
  surv_dev = 0,
  fec_dev = 0,
  density = NA,
  fecmod = 1,
  random.inda = FALSE,
  random.indb = FALSE,
  random.indc = FALSE,
  negfec = FALSE,
  reduce = FALSE,
  simple = FALSE,
  err_check = FALSE,
  exp_tol = 700,
  theta_tol = 1e+08,
  sparse_output = FALSE
)
}
\arguments{
\item{year}{A variable corresponding to observation occasion, or a set
of such values, given in values associated with the year term used in linear 
model development. Defaults to \code{"all"}, in which case matrices will be
estimated for all occasions.}

\item{patch}{A variable designating which patches or subpopulations will have
matrices estimated. Defaults to \code{"all"}, but can also be set to specific
patch names or a vector thereof.}

\item{prebreeding}{A logical value indicating whether the life history model
is a pre-breeding model. Defaults to \code{TRUE}.}

\item{data}{The historical vertical demographic data frame used to estimate
vital rates (class \code{hfvdata}). The original data frame is generally
required in order to initialize occasions and patches properly, and to assess
the range of ages observed in the population. Not required if option
\code{modelsuite} is set to a \code{vrm_input} object.}

\item{modelsuite}{One of three kinds of lists. The first is a \code{lefkoMod}
object holding the vital rate models and associated metadata. The second is
a \code{lefkoModList} object, which is a list of \code{lefkoMod} objects
generally created to conduct a bootstrapped MPM analysis. Alternatively,
an object of class \code{vrm_input} may be provided. If given, then
\code{surv_model}, \code{obs_model}, \code{size_model}, \code{sizeb_model},
\code{sizec_model}, \code{repst_model}, \code{fec_model}, \code{jsurv_model},
\code{jobs_model}, \code{jsize_model}, \code{jsizeb_model},
\code{jsizec_model}, \code{jrepst_model}, \code{jmatst_model}, and
\code{paramnames} are not required. One or more of these models should
include size or reproductive status in occasion \emph{t}-1. Although this is
optional input, it is recommended, and without it all vital rate model inputs
(named \code{XX_model}) are required.}

\item{surv_model}{A linear model predicting survival probability. This can be
a model of class \code{glm} or \code{glmer}, and requires a predicted
binomial variable under a logit link. Ignored if \code{modelsuite} is
provided. This model must have been developed in a modeling exercise testing
only the impacts of occasion \emph{t}.}

\item{fec_model}{A linear model predicting fecundity. This can be a model of
class \code{glm}, \code{glmer}, \code{glmmTMB}, \code{zeroinfl},
\code{vglm}, \code{lm}, or \code{lmer}. Ignored if \code{modelsuite} is
provided. This model must have been developed in a modeling exercise testing
only the impacts of occasion \emph{t}.}

\item{paramnames}{A data frame with three columns, the first describing all
terms used in linear modeling, the second (must be called \code{mainparams})
giving the general model terms that will be used in matrix creation, and the
third showing the equivalent terms used in modeling (must be named
\code{modelparams}). Function \code{\link{create_pm}()} can be used to
create a skeleton \code{paramnames} object, which can then be edited. Only
required if \code{modelsuite} is not supplied.}

\item{supplement}{An optional data frame of class \code{lefkoSD} that
provides supplemental data that should be incorporated into the MPM. Three
kinds of data may be integrated this way: transitions to be estimated via the
use of proxy transitions, transition overwrites from the literature or
supplemental studies, and transition multipliers for survival and fecundity.
This data frame should be produced using the \code{\link{supplemental}()}
function.}

\item{start_age}{The age from which to start the matrix. Defaults to
\code{NA}, in which case age \code{1} is used if \code{prebreeding = TRUE},
and age \code{0} is used if \code{prebreeding = FALSE}.}

\item{last_age}{The final age to use in the matrix. Defaults to \code{NA}, in
which case the highest age in the dataset is used.}

\item{fecage_min}{The minimum age at which reproduction is possible. Defaults
to \code{NA}, which is interpreted to mean that fecundity should be assessed
starting in the minimum age observed in the dataset.}

\item{fecage_max}{The maximum age at which reproduction is possible. Defaults
to \code{NA}, which is interpreted to mean that fecundity should be assessed
until the final observed age.}

\item{continue}{A logical value designating whether to allow continued
survival of individuals past the final age noted in the stageframe, using the 
demographic characteristics of the final age. Defaults to \code{TRUE}.}

\item{inda}{Can be a single value to use for individual covariate \code{a}
in all matrices, or a vector of such values corresponding to each occasion in
the dataset. Defaults to \code{NULL}.}

\item{indb}{Can be a single value to use for individual covariate \code{b}
in all matrices, or a vector of such values corresponding to each occasion in
the dataset. Defaults to \code{NULL}.}

\item{indc}{Can be a single value to use for individual covariate \code{c}
in all matrices, or a vector of such values corresponding to each occasion in
the dataset. Defaults to \code{NULL}.}

\item{annua}{Can be a single value to use for annual covariate \code{a}
in all matrices, a pair of values to use for times \emph{t} and \emph{t}-1 in
historical matrices, or a vector of such values corresponding to each
occasion in the dataset. Defaults to \code{NULL}.}

\item{annub}{Can be a single value to use for annual covariate \code{b}
in all matrices, a pair of values to use for times \emph{t} and \emph{t}-1 in
historical matrices, or a vector of such values corresponding to each
occasion in the dataset. Defaults to \code{NULL}.}

\item{annuc}{Can be a single value to use for annual covariate \code{c}
in all matrices, a pair of values to use for times \emph{t} and \emph{t}-1 in
historical matrices, or a vector of such values corresponding to each
occasion in the dataset. Defaults to \code{NULL}.}

\item{surv_dev}{A numeric value to be added to the y-intercept in the linear
model for survival probability. Defaults to \code{0}.}

\item{fec_dev}{A numeric value to be added to the y-intercept in the linear
model for fecundity. Defaults to \code{0}.}

\item{density}{A numeric value indicating density value to use to propagate
matrices. Only needed if density is an explanatory term used in linear
models. Defaults to \code{NA}.}

\item{fecmod}{A scalar multiplier of fecundity. Defaults to \code{1.0}.}

\item{random.inda}{A logical value denoting whether to treat individual
covariate \code{a} as a random, categorical variable. Otherwise is treated as
a fixed, numeric variable. Defaults to \code{FALSE}.}

\item{random.indb}{A logical value denoting whether to treat individual
covariate \code{b} as a random, categorical variable. Otherwise is treated as
a fixed, numeric variable. Defaults to \code{FALSE}.}

\item{random.indc}{A logical value denoting whether to treat individual
covariate \code{c} as a random, categorical variable. Otherwise is treated as
a fixed, numeric variable. Defaults to \code{FALSE}.}

\item{negfec}{A logical value denoting whether fecundity values estimated to
be negative should be reset to \code{0}. Defaults to \code{FALSE}.}

\item{reduce}{A logical value denoting whether to remove ages associated
solely with \code{0} transitions. These are only removed in cases where the
associated row and column sums in ALL matrices estimated equal 0. Defaults to
\code{FALSE}, and should generally not be used in age-based MPMs.}

\item{simple}{A logical value indicating whether to produce \code{A},
\code{U}, and \code{F} matrices, or only the latter two. Defaults to
\code{FALSE}, in which case all three are output.}

\item{err_check}{A logical value indicating whether to append extra
information used in matrix calculation within the output list. Defaults to
\code{FALSE}.}

\item{exp_tol}{A numeric value used to indicate a maximum value to set
exponents to in the core kernel to prevent numerical overflow. Defaults to
\code{700}.}

\item{theta_tol}{A numeric value used to indicate a maximum value to theta as
used in the negative binomial probability density kernel. Defaults to
\code{100000000}, but can be reset to other values during error checking.}

\item{sparse_output}{A logical value indicating whether to output matrices
in sparse format. Defaults to \code{FALSE}, in which case all matrices are
output in standard matrix format.}
}
\value{
If the user inputs a standard \code{lefkoMod} or \code{vrm_input}
object in argument \code{modelsuite}, or individual vital rate models are
input separately,then this function will return an object of class
\code{lefkoMat}. If the user inputs an object of class \code{lefkoModList}
in argument \code{modelsuite}, then the output will be an object of class
\code{lefkoMatList}, in which each element is an object of class
\code{lefkoMat}.

A \code{lefkoMat} object is a list that holds one full  matrix projection
model and all of its metadata. The structure has the following elements:

\item{A}{A list of full projection matrices in order of sorted patches and
occasions. All matrices output in R's \code{matrix} class, or in
the \code{dgCMatrix} class from the \code{Matrix} package if sparse.}
\item{U}{A list of survival transition matrices sorted as in \code{A}. All 
matrices output in R's \code{matrix} class, or in the \code{dgCMatrix} class
from the \code{Matrix} package if sparse.}
\item{F}{A list of fecundity matrices sorted as in \code{A}. All matrices 
output in R's \code{matrix} class, or in the \code{dgCMatrix} class from the
\code{Matrix} package if sparse.}
\item{hstages}{Set to \code{NA} for Leslie MPMs.}
\item{agestages}{Set to \code{NA} for Leslie MPMs.}
\item{ahstages}{A data frame detailing the characteristics of associated
ages, in the form of a modified stageframe including reproduction status.}
\item{labels}{A data frame giving the patch and year of each matrix in order.
In \code{fleslie()}, only one population may be analyzed at once.}
\item{dataqc}{A vector showing the numbers of individuals and rows in the
vertical dataset used as input.}
\item{matrixqc}{A short vector describing the number of non-zero elements in
\code{U} and \code{F} matrices, and the number of annual matrices.}
\item{modelqc}{This is the \code{qc} portion of the \code{modelsuite} input.}
\item{prob_out}{An optional element only added if \code{err_check = TRUE}.
This is a list of vital rate probability matrices, with 7 columns in the
order of survival, observation probability, reproduction probability, primary
size transition probability, secondary size transition probability, tertiary
size transition probability, and probability of juvenile transition to
maturity.}
}
\description{
Function \code{fleslie()} returns age-based (Leslie) MPMs corresponding to
the patches and occasions given, including the associated component
transition and fecundity matrices, data frames detailing the characteristics
of the exact ages corresponding to rows and columns in estimated matrices,
and a data frame characterizing the patch and occasion combinations
corresponding to these matrices.
}
\section{Notes}{

Unlike \code{\link{rlefko2}()}, \code{\link{rlefko3}()},
\code{\link{arlefko2}()}, and \code{\link{rleslie}()}, this function does not
currently distinguish populations.

This function will yield incorrect estimates if the models utilized
incorporate state in occasion \emph{t}-1, or any size or reproductive status
terms.

Users may at times wish to estimate MPMs using a dataset incorporating
multiple patches or subpopulations, but without discriminating between those
patches or subpopulations. Should the aim of analysis be a general MPM that
does not distinguish these patches or subpopulations, the
\code{modelsearch()} run should not include patch terms.

Input options including multiple variable names must be entered in the order
of variables in occasion \emph{t}+1 and \emph{t}. Rearranging the order will
lead to erroneous calculations, and may lead to fatal errors.

Care should be taken to match the random status of year and patch to the
states of those variables within the modelsuite. If they do not match, then
they will be treated as zeroes in vital rate estimation.

Individual covariates are treated as categorical only if they are set as
random terms. Fixed categorical individual covariates are currently not
allowed. However, such terms may be supplied if the \code{modelsuite} option
is set to a \code{vrm_input} object. In that case, the user should also set
the logical random switch for the individual covariate to be used to 
\code{TRUE} (e.g., \code{random.inda = TRUE}).
}

\examples{
data(lathyrus)

lathvert_base <- verticalize3(lathyrus, noyears = 4, firstyear = 1988,
  patchidcol = "SUBPLOT", individcol = "GENET", blocksize = 9,
  sizeacol = "Volume88", repstracol = "FCODE88", fecacol = "Intactseed88",
  deadacol = "Dead1988", censorcol = "Missing1988", censorkeep = NA,
  censor = TRUE, NAas0 = TRUE, NRasRep = TRUE, NOasObs = TRUE)

lathvert_base$feca3 <- round(lathvert_base$feca3)
lathvert_base$feca2 <- round(lathvert_base$feca2)
lathvert_base$feca1 <- round(lathvert_base$feca1)

lathvert_age <- subset(lathvert_base, firstseen > 1988)

lath_survival <- glm(alive3 ~ obsage + as.factor(year2), data = lathvert_age,
  family = "binomial")
lath_fecundity <- glm(feca2 ~ obsage + as.factor(year2), data = lathvert_age,
  family = "poisson")

mod_params <- create_pm(name_terms = TRUE)
mod_params$modelparams[22] <- "obsage"

lathmat2fleslie <- fleslie(year = "all", data = lathvert_age,
  surv_model = lath_survival, fec_model = lath_fecundity,
  paramnames = mod_params, fecage_min = 1)
  
}
\seealso{
\code{\link{mpm_create}()}

\code{\link{flefko3}()}

\code{\link{flefko2}()}

\code{\link{aflefko2}()}

\code{\link{arlefko2}()}

\code{\link{rlefko3}()}

\code{\link{rlefko2}()}

\code{\link{rleslie}()}
}
