% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranking.R
\name{lev_best_match}
\alias{lev_best_match}
\title{Get the best matched string from a list of candidates}
\usage{
lev_best_match(input, candidates, .fn = lev_ratio, ..., decreasing = TRUE)
}
\arguments{
\item{input}{A single string}

\item{candidates}{One or more candidate strings to score}

\item{.fn}{The scoring function to use, as a string or function object. Defaults to
\code{\link[=lev_ratio]{lev_ratio()}}.}

\item{...}{Additional arguments to pass to \code{.fn}.}

\item{decreasing}{If \code{TRUE} (the default), the candidate with the highest score is ranked first.
If using a comparison \code{.fn} that computes \emph{distance} rather than similarity, or if you want the
worst match to be returned first, set this to \code{FALSE}.}
}
\value{
A string
}
\description{
Given an \code{input} string and multiple \code{candidates}, return the candidate with the best score as
calculated by \code{.fn}.
}
\examples{
lev_best_match("bilbo", c("frodo", "gandalf", "legolas"))
}
\seealso{
\code{\link[=lev_score_multiple]{lev_score_multiple()}}
}
