% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_levels.R
\name{standardize_threshold}
\alias{standardize_threshold}
\alias{is_threshold}
\alias{standardize_log_level}
\alias{is_log_level}
\alias{standardize_log_levels}
\alias{is_log_levels}
\title{Standardize User-Input Log Levels to Their Integer Representation}
\usage{
standardize_threshold(
  x,
  log_levels = c(getOption("lgr.log_levels"), c(all = NA_integer_, off = 0L))
)

is_threshold(x)

standardize_log_level(x, log_levels = getOption("lgr.log_levels"))

is_log_level(x)

standardize_log_levels(x, log_levels = getOption("lgr.log_levels"))

is_log_levels(x)
}
\arguments{
\item{x}{a \code{character} or \code{integer} scalar, or vector for
standardize_log_levels}

\item{log_levels}{named \code{integer} vector of valid log levels}
}
\value{
An unnamed \code{integer} vector
}
\description{
These are helper functions for verifying log levels and converting them from
their character to their integer representations. This is primarily useful
if you want to build your own \link{Loggers}, \link{Appenders} or \link{Layouts} and need
to handle log levels in a way that is consistent with \pkg{lgr} .
}
\examples{

standardize_threshold("info")
standardize_threshold("all")
is_threshold("all")
is_threshold("foobar")

standardize_log_level("info")
# all is a valid threshold, but not a valid log level
try(is.na(standardize_log_level("all")))
is_log_level("all")

# standardized_log_level intentionally only works with scalars, because many
# functions require scalar log level inputs
try(standardize_log_level(c("info", "fatal")))

# You can still use standardize_log_levels() (plural) to work with vectors
standardize_log_levels(c("info", "fatal"))
}
\seealso{
Other docs relevant for extending lgr: 
\code{\link{LogEvent}},
\code{\link{as_LogEvent}()},
\code{\link{event_list}()}
}
\concept{docs relevant for extending lgr}
