% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{boston_pts}
\alias{boston_pts}
\title{Boston Housing Data with Geographic Coordinates}
\format{
A data frame with 506 observations and 20 variables:
\describe{
  \item{TOWN}{Town name (factor with 92 levels)}
  \item{TOWNNO}{Town number (integer)}
  \item{TRACT}{Census tract number (integer)}
  \item{LON}{Longitude (numeric)}
  \item{LAT}{Latitude (numeric)}
  \item{MEDV}{Median value of owner-occupied homes in USD 1,000s (numeric, censored at 50)}
  \item{CMEDV}{Corrected median value of owner-occupied homes (numeric)}
  \item{CRIM}{Per capita crime rate by town (numeric)}
  \item{ZN}{Proportion of residential land zoned for lots over 25,000 sq.ft. (numeric)}
  \item{INDUS}{Proportion of non-retail business acres per town (numeric)}
  \item{CHAS}{Charles River dummy variable (factor: "0" = not bounded, "1" = bounded)}
  \item{NOX}{Nitric oxides concentration (parts per 10 million, numeric)}
  \item{RM}{Average number of rooms per dwelling (numeric)}
  \item{AGE}{Proportion of owner-occupied units built prior to 1940 (numeric)}
  \item{DIS}{Weighted distances to five Boston employment centers (numeric)}
  \item{RAD}{Index of accessibility to radial highways (integer)}
  \item{TAX}{Full-value property-tax rate per \code{$10,000} (integer)}
  \item{PTRATIO}{Pupil-teacher ratio by town (numeric)}
  \item{B}{Proportion of Black residents, defined as 1000(Bk - 0.63)^2 (numeric)}
  \item{LSTAT}{Percentage of lower status of the population (numeric)}
}
}
\source{
Data taken from the \pkg{spData} package version 2.3.4
}
\usage{
data(boston_pts)
}
\description{
This dataset, \code{boston_pts}, is a data frame containing information on housing values
and neighborhood characteristics in the Boston area. It is based on the classic dataset
by Harrison and Rubinfeld (1978), corrected for minor errors and augmented with the latitude
and longitude of the observations. Gilley and Pace also note that the \code{MEDV} variable
is censored, with values at or over USD 50,000 set to USD 50,000.
}
\details{
The dataset consists of 506 observations and 20 variables, including socio-economic,
environmental, and housing characteristics. Geographic coordinates (longitude and latitude)
are provided for spatial analysis. Related data objects include \code{boston.utm}, a matrix
of tract point coordinates projected to UTM zone 19, and \code{boston.soi}, a sphere of
influence neighbors list.

The dataset name has been kept as \code{boston_pts} to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
\code{lightsf} package and assists users in identifying its specific characteristics.
The suffix \code{pts} indicates that the dataset includes spatial point information.
The original content has not been modified in any way.
}
