% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-generics.R
\docType{package}
\name{likelihood.model-package}
\alias{likelihood.model}
\alias{likelihood.model-package}
\title{likelihood.model: Likelihood-Based Inference in the Fisherian Tradition}
\description{
The \code{likelihood.model} package provides a framework for likelihood-based
inference. The package is organized in layers:

\strong{Core Concept} (\code{core-generics.R}):
The \code{likelihood_model} "concept" -- an abstract interface that any model
can implement. At minimum, implement \code{\link[=loglik]{loglik()}}. Optionally provide
\code{\link[=score]{score()}} and \code{\link[=hess_loglik]{hess_loglik()}} for analytical derivatives; defaults use
numerical differentiation via \code{numDeriv}.

\strong{Core Infrastructure}:
\itemize{
\item \link{fisher_mle} / \link{fisher_boot}: Result objects from MLE fitting, with
methods for \code{\link[=coef]{coef()}}, \code{\link[=vcov]{vcov()}}, \code{\link[=confint]{confint()}}, \code{\link[=se]{se()}}, \code{\link[=aic]{aic()}}, \code{\link[=bic]{bic()}},
\code{\link[=summary]{summary()}}.
\item \code{\link[=fit]{fit()}}: Default MLE solver using \code{\link[=optim]{optim()}}. Models can override this
with closed-form solutions (see \link{exponential_lifetime} for an example).
\item Fisherian inference: \code{\link[=support]{support()}}, \code{\link[=relative_likelihood]{relative_likelihood()}},
\code{\link[=likelihood_interval]{likelihood_interval()}}, \code{\link[=profile_loglik]{profile_loglik()}}, \code{\link[=evidence]{evidence()}} -- pure
likelihood-based inference without probability statements.
\item \code{\link[=lrt]{lrt()}}: Likelihood ratio test for nested models.
}

\strong{Model Builders}:
\itemize{
\item \link{likelihood_contr_model}: R6 class for building models from
heterogeneous observation types (exact, censored, etc.) with
dynamic dispatch to type-specific functions.
\item \code{\link[=likelihood_name]{likelihood_name()}}: Wraps any standard R distribution (norm, weibull,
exp, ...) with automatic censoring support.
}

\strong{Example Implementations}:
Reference implementations showing how to satisfy the \code{likelihood_model}
concept with hand-derived analytical solutions:
\itemize{
\item \link{weibull_uncensored}: Weibull with exact observations only.
Demonstrates analytical score and hessian (10-100x faster than numerical).
\item \link{exponential_lifetime}: Exponential with right-censoring support.
Demonstrates closed-form MLE (no optim needed), analytical FIM,
and \code{\link[=rdata]{rdata()}} for Monte Carlo validation.
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/queelius/likelihood.model}
  \item \url{https://queelius.github.io/likelihood.model/}
  \item Report bugs at \url{https://github.com/queelius/likelihood.model/issues}
}

}
\author{
\strong{Maintainer}: Alexander Towell \email{lex@metafunctor.com} (\href{https://orcid.org/0000-0001-6443-9897}{ORCID})

}
