% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/otb_run.R
\name{runOTB_isolated}
\alias{runOTB_isolated}
\title{Execute an OTB application in an isolated OTB environment (mainly Windows)}
\usage{
runOTB_isolated(otbCmdList, gili = NULL, retCommand = FALSE, quiet = TRUE)
}
\arguments{
\item{otbCmdList}{Non-empty list. `otbCmdList[[1]]` is the OTB application name.
Named entries are parameter keys without leading dashes.}

\item{gili}{Optional list from [linkOTB()]. If `NULL`, [linkOTB()] is called.}

\item{retCommand}{Logical. If `TRUE`, returns the exact shell command that would
be executed instead of running it.}

\item{quiet}{Logical. If `TRUE`, suppresses stdout/stderr (best-effort).}
}
\value{
If `retCommand=TRUE`, a character scalar command line. Otherwise an
  invisible status code.
}
\description{
- Windows: dot-sources `otbenv.ps1` (preferred) or calls `otbenv.bat`, then runs
  `otbcli` within the same shell session.
- Linux/macOS: delegates to [runOTB()] (launcher + explicit env already used).
}
