% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/otb_windows_search.R
\name{searchOTBW}
\alias{searchOTBW}
\title{Search for OTB installations on Windows (bounded, cmd-free)}
\usage{
searchOTBW(searchLocation = "C:/", DL = NULL, maxdepth = 8L, quiet = FALSE)
}
\arguments{
\item{searchLocation}{Character scalar. Root directory to search
(default \code{"C:/"}).}

\item{DL}{Character scalar. Deprecated alias for \code{searchLocation}.}

\item{maxdepth}{Integer. Best-effort maximum recursion depth for the
recursive \code{list.files()} search (default \code{8}).}

\item{quiet}{Logical. If \code{TRUE}, suppress messages.}
}
\value{
A \code{data.frame} with one row per detected installation and columns:
\describe{
  \item{binDir}{Normalized path to \code{<root>/bin}.}
  \item{baseDir}{Normalized OTB root directory.}
  \item{otbCmd}{Path to a detected CLI wrapper (ps1/bat/exe).}
  \item{envScript}{Path to \code{otbenv.ps1} or \code{otbenv.bat}.}
  \item{launcher}{Path to \code{otbApplicationLauncherCommandLine.exe}.}
  \item{installation_type}{Classification string (e.g., \code{"OTB_STANDALONE_PS1"}).}
}
}
\description{
Detects Orfeo Toolbox (OTB) installations on Windows using a bounded set of
plausible roots (no full-disk crawl). Modern standalone bundles (OTB 9.x)
are detected by the presence of:
\itemize{
  \item an environment script: \code{otbenv.ps1} (preferred) or \code{otbenv.bat}
  \item a launcher: \code{bin/otbApplicationLauncherCommandLine.exe}
  \item at least one CLI wrapper in \code{bin/}:
    \code{otbcli_*.ps1}, \code{otbcli_*.bat}, or \code{otbcli_*.exe}
}
}
\details{
Backward compatibility: older callers may pass \code{DL} instead of
\code{searchLocation}. Internally, \code{DL} is treated as an alias for
\code{searchLocation}.
}
\examples{
\dontrun{
# bounded search under C:/
searchOTBW("C:/", quiet = FALSE)

# legacy alias
searchOTBW(DL = "C:/", quiet = FALSE)
}

}
