% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llmhelper-package.R
\docType{package}
\name{llmhelper-package}
\alias{llmhelper-package}
\alias{llmhelper}
\title{llmhelper: Unified Interface for Large Language Model Interactions}
\description{
Provides a unified interface for interacting with Large Language Models (LLMs) through various providers including OpenAI \url{https://platform.openai.com/docs/api-reference}, Ollama \url{https://ollama.com/}, and other OpenAI-compatible APIs. Features include automatic connection testing, max_tokens limit auto-adjustment, structured JSON responses with schema validation, interactive JSON schema generation, prompt templating, and comprehensive diagnostics.

The llmhelper package provides a unified and user-friendly interface for
interacting with Large Language Models (LLMs) through various providers
including OpenAI, Ollama, and other OpenAI-compatible APIs.
}
\section{Main Functions}{

\describe{
\item{\code{\link{llm_provider}}}{Create an OpenAI-compatible LLM provider}
\item{\code{\link{llm_ollama}}}{Create an Ollama LLM provider}
\item{\code{\link{get_llm_response}}}{Get text or JSON responses from LLM}
\item{\code{\link{build_prompt}}}{Build prompts from templates}
\item{\code{\link{set_prompt}}}{Create prompt objects}
\item{\code{\link{generate_json_schema}}}{Interactively generate JSON schemas}
\item{\code{\link{diagnose_llm_connection}}}{Debug connection issues}
}
}

\section{Ollama Functions}{

\describe{
\item{\code{\link{ollama_list_models}}}{List available Ollama models}
\item{\code{\link{ollama_download_model}}}{Download Ollama models}
\item{\code{\link{ollama_delete_model}}}{Delete Ollama models}
}
}

\section{Environment Variables}{

The package uses the following environment variables:
\describe{
\item{LLM_API_KEY}{Default API key for LLM providers}
\item{OPENAI_API_KEY}{OpenAI API key}
\item{DEEPSEEK_API_KEY}{DeepSeek API key}
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/Zaoqu-Liu/llmhelper}
  \item Report bugs at \url{https://github.com/Zaoqu-Liu/llmhelper/issues}
}


Useful links:
\itemize{
\item \url{https://github.com/Zaoqu-Liu/llmhelper}
\item Report bugs at \url{https://github.com/Zaoqu-Liu/llmhelper/issues}
}
}
\author{
\strong{Maintainer}: Zaoqu Liu \email{liuzaoqu@163.com} (\href{https://orcid.org/0000-0002-0452-742X}{ORCID})


Zaoqu Liu \email{liuzaoqu@163.com}
}
\keyword{internal}
