#' Example datalist
#'
#' Fictional dataset containing the necessary information to run an equal pay
#' analysis.
#'
#' @format A data frame with 285 rows and 23 variables:
#' \describe{
#'   \item{personal_number}{personal number of the employee, alphanumeric},
#'   \item{age}{age, in years},
#'   \item{sex}{sex, M = male, F = female},
#'   \item{years_of_service}{years of service, in years},
#'   \item{training}{training code, 1-8},
#'   \item{professional_function}{function / job},
#'   \item{level_of_requirements}{level of requirements code, 1-8},
#'   \item{professional_position}{professional position / hierarchy code, 1-5},
#'   \item{activity_rate}{activity rate, in percent},
#'   \item{paid_hours}{paid hours, in hours},
#'   \item{basic_wage}{basic wage, in CHF},
#'   \item{allowances}{allowances, in CHF},
#'   \item{monthly_wage_13}{13th monthly wage, in CHF},
#'   \item{special_payments}{special payments, in CHF},
#'   \item{weekly_hours}{weekly contractual hours, in hours},
#'   \item{annual_hours}{annual contractual hours, in hours},
#'   \item{population}{analysis population code, 1-5},
#'   \item{comments}{comments for the employee},
#'   \item{supplement1}{additional remarks (1 of 5)},
#'   \item{supplement2}{additional remarks (2 of 5)},
#'   \item{supplement3}{additional remarks (3 of 5)},
#'   \item{supplement4}{additional remarks (4 of 5)},
#'   \item{supplement5}{additional remarks (5 of 5)}}
"datalist_example"


#' Column names
#'
#' List of column names used in the code, from the datalist and exportfiles
#' in all four languages (de, fr, it, en)
"all_column_names"
