% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/municipalities.R
\docType{data}
\name{Doubice_DC_cz}
\alias{Doubice_DC_cz}
\title{Municipal Election Data: Doubice (DC, CZ)}
\format{
An object of class \code{data.frame} with 151 rows and 14 columns.
}
\source{
The dataset was compiled primarily from official election results published by
the Czech Statistical Office. Additional contextual or verification information
(such as post-election roles) was obtained from publicly available municipal
records and interviews with local political representatives.
\itemize{
\item \href{https://www.volby.cz/index_en.htm}{Czech Statistical Office}
\item \href{https://oudoubice.cz/}{Municipality website}
\item Bubenicek, V. (2009). Doubice. In Cmejrek, J. et al.,
\emph{Participace obcanu na verejnem zivote venkovskych obci CR}
(Citizens' Participation in the Public Life of Rural Municipalities in the Czech Republic).
Prague: Kernberg Publishing.
}
}
\usage{
Doubice_DC_cz
}
\description{
A dataset containing individual-level candidacy records from municipal
elections in the municipality of Doubice (district Decin, Czech Republic).
}
\details{
\tabular{ll}{
   \strong{Dataset overview:} \tab  \cr
   Municipality: \tab Doubice \cr
   District: \tab Decin \cr
   Country: \tab Czech Republic \cr
   Number of elections: \tab 11 \cr
   Elections covered: \tab 1993, 1994, 1998, 2002, 2006, 2007, 2010, 2014, 2015, 2018, 2022 \cr
   Number of candidacies (rows): \tab 151 \cr
   Note: \tab \href{https://oudoubice.cz/}{Municipality website} \cr
}
}
\section{Description of variables}{
\tabular{ll}{
   \strong{Variable} \tab \strong{Description} \cr
   elections \tab Election identifiers (numeric) \cr
   candidate \tab Candidate's full name (character) \cr
   list_name \tab Name of the candidate list (character) \cr
   list_pos \tab Candidate's position on the list (numeric) \cr
   pref_votes \tab Number of preferential votes (numeric) \cr
   elected \tab Logical; TRUE if candidate was elected \cr
   nom_party \tab Nominating party (character) \cr
   pol_affil \tab Political affiliation (character) \cr
   mayor \tab TRUE if elected mayor \cr
   dep_mayor \tab TRUE if elected deputy mayor \cr
   board \tab TRUE if member of the executive board \cr
   gov_support \tab TRUE if supported the local government \cr
   elig_voters \tab Number of eligible voters (numeric) \cr
   ballots_cast \tab Number of ballots cast (numeric) \cr
}


Each record describes one candidate's run for office, including their candidate
list affiliation, position on the list, nominating party, political affiliation,
number of preferential votes, and whether they were elected or held specific
positions (mayor, deputy mayor, member of the executive body).

The dataset also includes contextual election-level information, such as the
number of eligible voters and ballots cast, which can be used to calculate
voter turnout and related indicators. These variables appear only once per
election and constituency (they may be stored in a single candidate row for
that election/constituency)
}

\examples{
# Basic inspection
str(Doubice_DC_cz)

# Example of a basic continuity diagram (unformatted version)
\donttest{plot_continuity(Doubice_DC_cz, elections = "2010-")}
}
\references{
\itemize{
\item Bubenicek, V. (2010). \emph{Lokalni modely demokracie v malych obcich CR}
(Local Models of Democracy in Small Municipalities). Dissertation thesis.
Czech University of Life Sciences Prague.
[\href{https://www.pef.czu.cz/dl/46317}{Full text}]
\item Bubenicek, V., & Kubalek, M. (2010). Konfliktni linie v malych obcich
(Cleavages in Small Municipalities). \emph{Acta Politologica}, 2(3), 30-45.
[\href{https://acpo.fsv.cuni.cz/ACPONEN-48-version1-acpo_2010_03_04.pdf}{Full text}]
\item Cmejrek, J., Bubenicek, V., & Copik, J. (2010). \emph{Demokracie v lokalnim politickem prostoru}
(Democracy in Local Political Area). Prague: Grada.
[\href{https://www.grada.cz/demokracie-v-lokalnim-politickem-prostoru-5880/}{Publisher link}]
\item Cmejrek, J. et al. (2009). \emph{Participace obcanu na verejnem zivote venkovskych obci CR}
(Citizens' Participation in the Public Life of Rural Municipalities in the Czech Republic).
Prague: Kernberg Publishing.
\item Bubenicek, V. (2009). Aplikace indexu plurality na lokalni politicke urovni
(The Application of the Plurality Index in the Local Politics). In
Svatos, M., Lostak, M., & Zuzak, R. (Eds.) \emph{Sbornik praci z mezinarodni vedecke}
\emph{konference Agrarni perspektivy XVIII. Strategie pro budoucnost.} Prague: FEM CZU Prague.
\item Bubenicek, V., Copik, J., Hajny, P., Kopriva, R., & Neumanova, T. (Eds.) (2005).
\emph{Obce jako akteri politickeho procesu: komunitni studie regionalnich politickych systemu}
\emph{a problematika metodiky jejich zpracovani} (Municipalities as Actors of the Political
Process: Case Studies of Regional Political Systems and Methodology of Their Elaboration).
Prague: FEM CZU Prague.
}
}
\keyword{datasets}
