% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openai_processor.R
\name{OpenAIProcessor}
\alias{OpenAIProcessor}
\title{OpenAI API Processor}
\description{
OpenAI API Processor

OpenAI API Processor
}
\details{
Concrete implementation of BaseAPIProcessor for OpenAI models.
Handles OpenAI-specific API calls, authentication, and response parsing.
}
\section{Super class}{
\code{\link[mLLMCelltype:BaseAPIProcessor]{mLLMCelltype::BaseAPIProcessor}} -> \code{OpenAIProcessor}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-OpenAIProcessor-new}{\code{OpenAIProcessor$new()}}
\item \href{#method-OpenAIProcessor-get_default_api_url}{\code{OpenAIProcessor$get_default_api_url()}}
\item \href{#method-OpenAIProcessor-make_api_call}{\code{OpenAIProcessor$make_api_call()}}
\item \href{#method-OpenAIProcessor-extract_response_content}{\code{OpenAIProcessor$extract_response_content()}}
\item \href{#method-OpenAIProcessor-clone}{\code{OpenAIProcessor$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mLLMCelltype" data-topic="BaseAPIProcessor" data-id="get_api_url"><a href='../../mLLMCelltype/html/BaseAPIProcessor.html#method-BaseAPIProcessor-get_api_url'><code>mLLMCelltype::BaseAPIProcessor$get_api_url()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mLLMCelltype" data-topic="BaseAPIProcessor" data-id="process_request"><a href='../../mLLMCelltype/html/BaseAPIProcessor.html#method-BaseAPIProcessor-process_request'><code>mLLMCelltype::BaseAPIProcessor$process_request()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenAIProcessor-new"></a>}}
\if{latex}{\out{\hypertarget{method-OpenAIProcessor-new}{}}}
\subsection{Method \code{new()}}{
Initialize OpenAI processor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenAIProcessor$new(base_url = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenAIProcessor-get_default_api_url"></a>}}
\if{latex}{\out{\hypertarget{method-OpenAIProcessor-get_default_api_url}{}}}
\subsection{Method \code{get_default_api_url()}}{
Get default OpenAI API URL
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenAIProcessor$get_default_api_url()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenAIProcessor-make_api_call"></a>}}
\if{latex}{\out{\hypertarget{method-OpenAIProcessor-make_api_call}{}}}
\subsection{Method \code{make_api_call()}}{
Make API call to OpenAI
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenAIProcessor$make_api_call(chunk_content, model, api_key)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenAIProcessor-extract_response_content"></a>}}
\if{latex}{\out{\hypertarget{method-OpenAIProcessor-extract_response_content}{}}}
\subsection{Method \code{extract_response_content()}}{
Extract response content from OpenAI API response
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenAIProcessor$extract_response_content(response, model)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenAIProcessor-clone"></a>}}
\if{latex}{\out{\hypertarget{method-OpenAIProcessor-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenAIProcessor$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
