% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symtable.R
\name{symget}
\alias{symget}
\title{Get a Variable Value from the Macro Symbol Table}
\usage{
symget(name)
}
\arguments{
\item{name}{The name of the macro variable as a quoted string, with no
leading ampersand or trailing dot (".").  The leading ampersand will
be added automatically by the function.  This
parameter is required.}
}
\value{
The value of the macro variable as a character string.  If the variable
name is not found, the function will return an NA.
}
\description{
The \code{symget} function extracts the value of a single macro variable
from the macro symbol table.
}
\examples{
library(macro)

# Get path to demo macro program
src <- system.file("extdata/Demo3.R", package = "macro")

# Display source code
# - This is the macro input code
cd <- readLines(src)
cat(paste(cd, "\n"))
# #\% Determine appropriate data path
# #\%if ("&env." == "prod")
#   #\%let pth <- /projects/prod/data
# #\%else
#   #\%let pth <- /projects/dev/data
# #\%end

# Set environment variable using symput()
symput("env", "prod")

# Macro Execute Source Code
# - set clear to FALSE to so "env" value is not removed
msource(src, echo = FALSE, clear = FALSE)

# View "pth" macro variable
res <- symget("pth")

# View results
# - Path is set to the "prod" value
res
# [1] "/projects/prod/data"

}
\seealso{
\code{\link[=msource]{msource()}}

Other symtable: 
\code{\link{print.symtable}()},
\code{\link{symclear}()},
\code{\link{symput}()},
\code{\link{symtable}()}
}
\concept{symtable}
