% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp-dict.R
\encoding{UTF-8}
\name{esp_dict_region_code}
\alias{esp_dict_region_code}
\alias{esp_dict_translate}
\title{Convert and translate Spanish subdivision names and codes}
\usage{
esp_dict_region_code(sourcevar, origin = "text", destination = "text")

esp_dict_translate(sourcevar, lang = "en", all = FALSE)
}
\arguments{
\item{sourcevar}{character string. Vector which contains the codes or names
to be converted.}

\item{origin, destination}{character string. Coding scheme of origin and
destination. One of \code{"text"}, \code{"nuts"}, \code{"iso2"}, \code{"codauto"}, or \code{"cpro"}.}

\item{lang}{character string. Target language code, available values:
\itemize{
\item \code{"es"}: Spanish.
\item \code{"en"}: English.
\item \code{"ca"}: Catalan.
\item \code{"ga"}: Galician.
\item \code{"eu"}: Basque.
}}

\item{all}{logical. If \code{TRUE} the function returns all possible translations
for each input as a named list. When \code{FALSE} (default) a single preferred
translation per input is returned as a character vector.}
}
\value{
\code{esp_dict_region_code()} returns a character vector with converted
subdivision identifiers or names. If a value cannot be matched the
corresponding element will be \code{NA} and a warning is emitted via
\code{\link[cli:cli_alert]{cli::cli_alert_warning()}}.

\code{esp_dict_translate()} translates a vector of names from one language to
another :
\itemize{
\item If \code{all = FALSE}, a character vector with the translated name for each
element of \code{sourcevar}.
\item If \code{all = TRUE}, a named \code{list} is returned where each element contains
all available translations for the corresponding input value.
}
}
\description{
Convert Spanish subdivision names or identifiers between different coding
schemes (NUTS, ISO2, province codes, etc.) or obtain human-readable
names.
}
\details{
The function uses internal dictionaries together with \CRANpkg{countrycode}
to map between schemes. When \verb{origin == destination == "text"} the input is
returned unchanged. Mixing names from different administrative levels
(for example autonomous community and province) may produce
\code{NA} values for some entries.
}
\examples{
vals <- c("Errioxa", "Coruna", "Gerona", "Madrid")

esp_dict_region_code(vals)
esp_dict_region_code(vals, destination = "nuts")
esp_dict_region_code(vals, destination = "cpro")
esp_dict_region_code(vals, destination = "iso2")

# From ISO2 to another codes

iso2vals <- c("ES-M", "ES-S", "ES-SG")
esp_dict_region_code(iso2vals, origin = "iso2")
esp_dict_region_code(iso2vals,
  origin = "iso2",
  destination = "nuts"
)
esp_dict_region_code(iso2vals,
  origin = "iso2",
  destination = "cpro"
)

# Mixing levels
valsmix <- c("Centro", "Andalucia", "Seville", "Menorca")
esp_dict_region_code(valsmix, destination = "nuts")

esp_dict_region_code(valsmix, destination = "codauto")
esp_dict_region_code(valsmix, destination = "iso2")

vals <- c("La Rioja", "Sevilla", "Madrid", "Jaen", "Orense", "Baleares")

esp_dict_translate(vals)
esp_dict_translate(vals, lang = "es")
esp_dict_translate(vals, lang = "ca")
esp_dict_translate(vals, lang = "eu")
esp_dict_translate(vals, lang = "ga")

esp_dict_translate(vals, lang = "ga", all = TRUE)
}
\concept{dictionary}
