% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\encoding{UTF-8}
\name{esp_tiles_providers}
\alias{esp_tiles_providers}
\title{Public WMS and WMTS providers for Spain}
\format{
A named \code{\link[base:list]{list}} of available providers with the following
structure:
\itemize{
\item Each list item is named with the provider alias.
\item Each element contains two nested named lists:
\itemize{
\item \code{static} with the parameters required to obtain static tiles, plus an
additional item named \code{attribution}.
\item \code{leaflet} with additional parameters to pass to \code{\link[=addProviderEspTiles]{addProviderEspTiles()}}.
}
}
}
\source{
\url{https://dieghernan.github.io/leaflet-providersESP/} leaflet plugin,
\strong{v1.3.3}.
}
\description{
A named \code{\link[base:list]{list}} of length 102
containing URL information for different public WMS and WMTS tile providers
of Spain.

Implementation of the JavaScript plugin
\href{https://dieghernan.github.io/leaflet-providersESP/}{leaflet-providersESP}
\strong{v1.3.3}.
}
\details{
Providers available to be passed to \code{type} on \code{\link[=esp_get_tiles]{esp_get_tiles()}} are:
\itemize{
\item \code{"IDErioja"}
\item \code{"IDErioja.Base"}
\item \code{"IDErioja.Relieve"}
\item \code{"IDErioja.Claro"}
\item \code{"IDErioja.Oscuro"}
\item \code{"IGNBase"}
\item \code{"IGNBase.Todo"}
\item \code{"IGNBase.Gris"}
\item \code{"IGNBase.TodoNoFondo"}
\item \code{"IGNBase.Orto"}
\item \code{"MDT"}
\item \code{"MDT.Elevaciones"}
\item \code{"MDT.Relieve"}
\item \code{"MDT.CurvasNivel"}
\item \code{"MDT.SpotElevation"}
\item \code{"PNOA"}
\item \code{"PNOA.MaximaActualidad"}
\item \code{"PNOA.Mosaico"}
\item \code{"OcupacionSuelo"}
\item \code{"OcupacionSuelo.Ocupacion"}
\item \code{"OcupacionSuelo.Usos"}
\item \code{"LiDAR"}
\item \code{"MTN"}
\item \code{"Geofisica"}
\item \code{"Geofisica.Terremotos10dias"}
\item \code{"Geofisica.Terremotos30dias"}
\item \code{"Geofisica.Terremotos365dias"}
\item \code{"Geofisica.ObservedEvents"}
\item \code{"Geofisica.HazardArea"}
\item \code{"VigilanciaVolcanica"}
\item \code{"VigilanciaVolcanica.ErupcionesHistoricas"}
\item \code{"CaminoDeSantiago"}
\item \code{"CaminoDeSantiago.CaminoFrances"}
\item \code{"CaminoDeSantiago.CaminosFrancia"}
\item \code{"CaminoDeSantiago.CaminosGalicia"}
\item \code{"CaminoDeSantiago.CaminosDelNorte"}
\item \code{"CaminoDeSantiago.CaminosAndaluces"}
\item \code{"CaminoDeSantiago.CaminosCentro"}
\item \code{"CaminoDeSantiago.CaminosEste"}
\item \code{"CaminoDeSantiago.CaminosCatalanes"}
\item \code{"CaminoDeSantiago.CaminosSureste"}
\item \code{"CaminoDeSantiago.CaminosInsulares"}
\item \code{"CaminoDeSantiago.CaminosPortugueses"}
\item \code{"Catastro"}
\item \code{"Catastro.Catastro"}
\item \code{"Catastro.Parcela"}
\item \code{"Catastro.CadastralParcel"}
\item \code{"Catastro.CadastralZoning"}
\item \code{"Catastro.Address"}
\item \code{"Catastro.Building"}
\item \code{"Catastro.BuildingPart"}
\item \code{"Catastro.AdministrativeBoundary"}
\item \code{"Catastro.AdministrativeUnit"}
\item \code{"RedTransporte"}
\item \code{"RedTransporte.Carreteras"}
\item \code{"RedTransporte.Ferroviario"}
\item \code{"RedTransporte.Aerodromo"}
\item \code{"RedTransporte.AreaServicio"}
\item \code{"RedTransporte.EstacionesFerroviario"}
\item \code{"RedTransporte.Puertos"}
\item \code{"Cartociudad"}
\item \code{"Cartociudad.CodigosPostales"}
\item \code{"Cartociudad.Direcciones"}
\item \code{"NombresGeograficos"}
\item \code{"UnidadesAdm"}
\item \code{"UnidadesAdm.Limites"}
\item \code{"UnidadesAdm.Unidades"}
\item \code{"Hidrografia"}
\item \code{"Hidrografia.MasaAgua"}
\item \code{"Hidrografia.Cuencas"}
\item \code{"Hidrografia.Subcuencas"}
\item \code{"Hidrografia.POI"}
\item \code{"Hidrografia.ManMade"}
\item \code{"Hidrografia.LineaCosta"}
\item \code{"Hidrografia.Rios"}
\item \code{"Hidrografia.Humedales"}
\item \code{"Militar"}
\item \code{"Militar.CEGET1M"}
\item \code{"Militar.CEGETM7814"}
\item \code{"Militar.CEGETM7815"}
\item \code{"Militar.CEGETM682"}
\item \code{"Militar.CECAF1M"}
\item \code{"ADIF"}
\item \code{"ADIF.Vias"}
\item \code{"ADIF.Nodos"}
\item \code{"ADIF.Estaciones"}
\item \code{"LimitesMaritimos"}
\item \code{"LimitesMaritimos.LimitesMaritimos"}
\item \code{"LimitesMaritimos.LineasBase"}
\item \code{"Copernicus"}
\item \code{"Copernicus.Forest"}
\item \code{"Copernicus.ForestLeaf"}
\item \code{"Copernicus.WaterWet"}
\item \code{"Copernicus.SoilSeal"}
\item \code{"Copernicus.GrassLand"}
\item \code{"Copernicus.RiparianGreen"}
\item \code{"Copernicus.RiparianLandCover"}
\item \code{"Copernicus.Natura2k"}
\item \code{"Copernicus.UrbanAtlas"}
\item \code{"ParquesNaturales"}
\item \code{"ParquesNaturales.Limites"}
\item \code{"ParquesNaturales.ZonasPerifericas"}
}
}
\examples{
data("esp_tiles_providers")
# Get a single provider

single <- esp_tiles_providers[["IGNBase.Todo"]]
single$static

single$leaflet

}
\seealso{
Other datasets: 
\code{\link{esp_codelist}},
\code{\link{esp_nuts_2024}},
\code{\link{pobmun25}}
}
\concept{datasets}
