% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_mappoly.R
\name{read_geno}
\alias{read_geno}
\alias{print.mappoly.data}
\alias{plot.mappoly.data}
\title{Data Input}
\usage{
read_geno(
  file.in,
  filter.non.conforming = TRUE,
  elim.redundant = TRUE,
  verbose = TRUE
)

\method{print}{mappoly.data}(x, detailed = FALSE, ...)

\method{plot}{mappoly.data}(x, thresh.line = 1e-05, ...)
}
\arguments{
\item{file.in}{a character string with the name of (or full path to) the input file
which contains the data to be read}

\item{filter.non.conforming}{if \code{TRUE} (default) converts data points with unexpected 
genotypes (i.e. no double reduction) to 'NA'. See function \code{\link[mappoly]{segreg_poly}} 
for information on expected classes and their respective frequencies.}

\item{elim.redundant}{logical. If \code{TRUE} (default), removes redundant markers
during map construction, keeping them annotated to export to the final map.}

\item{verbose}{if \code{TRUE} (default), the current progress is shown; if
\code{FALSE}, no output is produced}

\item{x}{an object of class \code{mappoly.data}}

\item{detailed}{if available, print the number of markers per sequence (default = FALSE)}

\item{...}{currently ignored}

\item{thresh.line}{position of a threshold line for p values of the segregation test (default = 10e-06)}
}
\value{
An object of class \code{mappoly.data} which contains a
    list with the following components:
    \item{ploidy}{ploidy level}
    \item{n.ind}{number individuals}
    \item{n.mrk}{total number of markers}
    \item{ind.names}{the names of the individuals}
    \item{mrk.names}{the names of the markers}
    \item{dosage.p1}{a vector containing the dosage in
      parent P for all \code{n.mrk} markers}
    \item{dosage.p2}{a vector containing the dosage in
      parent Q for all \code{n.mrk} markers}
    \item{chrom}{a vector indicating which sequence each marker
      belongs. Zero indicates that the marker was not assigned to any
      sequence}
    \item{genome.pos}{Physical position of the markers into the
      sequence}
    \item{seq.ref}{NULL (unused in this type of data)}
    \item{seq.alt}{NULL (unused in this type of data)}
    \item{all.mrk.depth}{NULL (unused in this type of data)}
    \item{geno.dose}{a matrix containing the dosage for each markers (rows) 
      for each individual (columns). Missing data are represented by 
      \code{ploidy_level + 1}}
    \item{n.phen}{number of phenotypic traits}
    \item{phen}{a matrix containing the phenotypic data. The rows
                correspond to the traits and the columns correspond
                to the individuals}
    \item{kept}{if elim.redundant = TRUE, holds all non-redundant markers}
    \item{elim.correspondence}{if elim.redundant = TRUE, holds all non-redundant markers and
its equivalence to the redundant ones}
}
\description{
Reads an external data file. The format of the file is described in the \code{Details}
section. This function creates an object of class \code{mappoly.data}
}
\details{
The first line of the input file contains the string \code{ploidy} followed by the ploidy level of the parents.
The second and third lines contain the strings \code{n.ind} and \code{n.mrk} followed by the number of individuals in 
the dataset and the total number of markers, respectively. Lines number 4 and 5 contain the strings
\code{mrk.names} and \code{ind.names} followed by a sequence of the names of the markers and the name of the individuals, 
respectively. Lines 6 and 7 contain the strings \code{dosageP} and \code{dosageQ} followed by a sequence of numbers 
containing the dosage of all markers in parent \code{P} and \code{Q}. Line 8, contains the string seq followed by 
a sequence of integer numbers indicating the chromosome each marker belongs. It can be any 'a priori' 
information regarding the physical distance between markers. For example, these numbers could refer 
to chromosomes, scaffolds or even contigs, in which the markers are positioned. If this information 
is not available for a particular marker, NA should be used. If this information is not available for 
any of the markers, the string \code{seq} should be followed by a single \code{NA}. Line number 9 contains the string 
\code{seqpos} followed by the physical position of the markers into the sequence. The physical position can be 
given in any unity of physical genomic distance (base pairs, for instance). However, the user should be 
able to make decisions based on these values, such as the occurrence of crossing overs, etc. Line number 10 
should contain the string \code{nphen} followed by the number of phenotypic traits. Line number 11 is skipped 
(Usually used as a spacer). The next elements are strings containing the name of the phenotypic trait with no space characters
followed by the phenotypic values. The number of lines should be the same number of phenotypic traits. 
\code{NA} represents missing values. The line number 12 + \code{nphen} is skipped. Finally, the last element is a table
containing the dosage for each marker (rows) for each individual (columns). \code{NA} represents missing values.
}
\examples{
\donttest{
#### Tetraploid Example
fl1 = "https://raw.githubusercontent.com/mmollina/MAPpoly_vignettes/master/data/SolCAP_dosage"
tempfl <- tempfile()
download.file(fl1, destfile = tempfl)
SolCAP.dose <- read_geno(file.in  = tempfl)
print(SolCAP.dose, detailed = TRUE)
plot(SolCAP.dose)
}
}
\references{
Mollinari M., Olukolu B. A.,  Pereira G. da S., 
    Khan A., Gemenet D., Yencho G. C., Zeng Z-B. (2020), 
    Unraveling the Hexaploid Sweetpotato Inheritance 
    Using Ultra-Dense Multilocus Mapping, 
    _G3: Genes, Genomes, Genetics_. 
    \doi{10.1534/g3.119.400620} 
    
    Mollinari, M., and Garcia, A.  A. F. (2019) Linkage
    analysis and haplotype phasing in experimental autopolyploid
    populations with high ploidy level using hidden Markov
    models, _G3: Genes, Genomes, Genetics_. 
    \doi{10.1534/g3.119.400378}
}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu}
}
