% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_mappoly_vcf.R
\name{read_vcf}
\alias{read_vcf}
\title{Data Input VCF}
\usage{
read_vcf(
  file.in,
  parent.1,
  parent.2,
  ploidy = NA,
  filter.non.conforming = TRUE,
  thresh.line = 0.05,
  min.gt.depth = 0,
  min.av.depth = 0,
  max.missing = 1,
  elim.redundant = TRUE,
  verbose = TRUE,
  read.geno.prob = FALSE,
  prob.thres = 0.95
)
}
\arguments{
\item{file.in}{a character string with the name of (or full path to) the 
input file which contains the data (VCF format)}

\item{parent.1}{a character string containing the name of parent 1}

\item{parent.2}{a character string containing the name of parent 2}

\item{ploidy}{the species ploidy (optional, it will be automatically detected)}

\item{filter.non.conforming}{if \code{TRUE} (default) converts data points with unexpected 
genotypes (i.e. no double reduction) to 'NA'. See function \code{\link[mappoly]{segreg_poly}} 
for information on expected classes and their respective frequencies.}

\item{thresh.line}{threshold used for p-values on segregation test (default = 0.05)}

\item{min.gt.depth}{minimum genotype depth to keep information. 
If the genotype depth is below \code{min.gt.depth},
it will be replaced with NA (default = 0)}

\item{min.av.depth}{minimum average depth to keep markers (default = 0)}

\item{max.missing}{maximum proportion of missing data to keep markers (range = 0-1; default = 1)}

\item{elim.redundant}{logical. If \code{TRUE} (default), removes redundant markers
during map construction, keeping them annotated to export to the final map.}

\item{verbose}{if \code{TRUE} (default), the current progress is shown; if
\code{FALSE}, no output is produced}

\item{read.geno.prob}{If genotypic probabilities are available (PL field),
generates a probability-based dataframe (default = \code{FALSE}).}

\item{prob.thres}{probability threshold to associate a marker call to a 
dosage. Markers with maximum genotype probability smaller than \code{prob.thres} 
are considered as missing data for the dosage calling purposes (default = 0.95)}
}
\value{
An object of class \code{mappoly.data} which contains a
    list with the following components:
    \item{ploidy}{ploidy level}
    \item{n.ind}{number individuals}
    \item{n.mrk}{total number of markers}
    \item{ind.names}{the names of the individuals}
    \item{mrk.names}{the names of the markers}
    \item{dosage.p1}{a vector containing the dosage in
      parent P for all \code{n.mrk} markers}
    \item{dosage.p2}{a vector containing the dosage in
      parent Q for all \code{n.mrk} markers}
    \item{chrom}{a vector indicating which sequence each marker
      belongs. Zero indicates that the marker was not assigned to any
      sequence}
    \item{genome.pos}{Physical position of the markers into the
      sequence}
    \item{seq.ref}{Reference base used for each marker (i.e. A, T, C, G)}
    \item{seq.alt}{Alternative base used for each marker (i.e. A, T, C, G)}
    \item{prob.thres}{(unused field)}
    \item{geno.dose}{a matrix containing the dosage for each markers (rows) 
      for each individual (columns). Missing data are represented by 
      \code{ploidy_level + 1}}
    \item{geno}{a dataframe containing all genotypic probabilities columns for each
      marker and individual combination (rows). Missing data are represented by 
      \code{ploidy_level + 1}}
    \item{nphen}{(unused field)}
    \item{phen}{(unused field)}
    \item{all.mrk.depth}{DP information for all markers on VCF file}
    \item{chisq.pval}{a vector containing p-values related to the chi-squared 
    test of Mendelian segregation performed for all markers}
    \item{kept}{if elim.redundant = TRUE, holds all non-redundant markers}
    \item{elim.correspondence}{if elim.redundant = TRUE, holds all non-redundant markers and
its equivalence to the redundant ones}
}
\description{
Reads an external VCF file and creates an object of class \code{mappoly.data}
}
\details{
This function can handle .vcf files versions 4.0 or higher. The ploidy 
can be automatically detected, but it is highly recommended that you 
inform it to check for mismatches. All individual and marker names 
will be kept as they are in the .vcf file.
}
\examples{
\donttest{
## Hexaploid sweetpotato: Subset of chromosome 3
fl = "https://github.com/mmollina/MAPpoly_vignettes/raw/master/data/sweet_sample_ch3.vcf.gz"
tempfl <- tempfile(pattern = 'chr3_', fileext = '.vcf.gz')
download.file(fl, destfile = tempfl)
dat.dose.vcf = read_vcf(file = tempfl, parent.1 = "PARENT1", parent.2 = "PARENT2")
print(dat.dose.vcf)
plot(dat.dose.vcf)
}

}
\references{
Mollinari M., Olukolu B. A.,  Pereira G. da S., 
    Khan A., Gemenet D., Yencho G. C., Zeng Z-B. (2020), 
    Unraveling the Hexaploid Sweetpotato Inheritance 
    Using Ultra-Dense Multilocus Mapping, 
    _G3: Genes, Genomes, Genetics_. 
    \doi{10.1534/g3.119.400620} 
    
    Mollinari, M., and Garcia, A.  A. F. (2019) Linkage
    analysis and haplotype phasing in experimental autopolyploid
    populations with high ploidy level using hidden Markov
    models, _G3: Genes, Genomes, Genetics_. 
    \doi{10.1534/g3.119.400378}
}
\author{
Gabriel Gesteira, \email{gdesiqu@ncsu.edu}
}
