% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F14.R
\name{F14}
\alias{F14}
\title{Shekel's Foxholes Function (F14)}
\usage{
F14(x)
}
\arguments{
\item{x}{Numeric vector of length 2 (2-dimensional input).}
}
\value{
Numeric scalar representing the function value.
}
\description{
A multimodal test function with 25 local minima of different depths,
arranged in a grid pattern. Fixed dimension of 2.
}
\details{
\strong{Formula:}
\deqn{f(x) = \left(\frac{1}{500} +
  \sum_{j=1}^{25}\frac{1}{j + \sum_{i=1}^{2}(x_i - a_{ij})^6}\right)^{-1}}

where \eqn{a_{ij}} are predefined constants forming a 5x5 grid.

\strong{Global minimum:} \eqn{f(-32, -32) \approx 0.998}

\strong{Characteristics:}
\itemize{
  \item Type: Multimodal
  \item Separable: No
  \item Differentiable: Yes
  \item Fixed dimension: 2
  \item Number of local minima: 25
  \item Default bounds: \eqn{[-65.536, 65.536]^2}
}

The 25 minima are located at points from a 5x5 grid with coordinates
\eqn{(-32, -16, 0, 16, 32)} in each dimension.
}
\examples{
F14(c(-32, -32))  # Returns approximately 0.998 (global minimum)
F14(c(0, 0))      # Returns approximately 10

}
\seealso{
\code{\link{test-functions}} for an overview of all test functions,
\code{\link{get_function_details}} to retrieve function parameters.
}
