% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F15.R
\name{F15}
\alias{F15}
\title{Kowalik Function (F15)}
\usage{
F15(x)
}
\arguments{
\item{x}{Numeric vector of length 4 (4-dimensional input).}
}
\value{
Numeric scalar representing the function value.
}
\description{
A multimodal test function used for testing optimization algorithms,
based on fitting experimental data. Fixed dimension of 4.
}
\details{
\strong{Formula:}
\deqn{f(x) = \sum_{i=1}^{11}\left(a_i -
  \frac{x_1(b_i^2 + b_i x_2)}{b_i^2 + b_i x_3 + x_4}\right)^2}

where \eqn{a_i} and \eqn{b_i} are predefined constants from experimental data.

\strong{Global minimum:} \eqn{f(0.1928, 0.1908, 0.1231, 0.1358) \approx 0.0003075}

\strong{Characteristics:}
\itemize{
  \item Type: Multimodal
  \item Separable: No
  \item Differentiable: Yes
  \item Fixed dimension: 4
  \item Default bounds: \eqn{[-5, 5]^4}
}

This function is derived from a curve-fitting problem and has several
local minima near the global minimum.
}
\examples{
F15(c(0.1928, 0.1908, 0.1231, 0.1358))  # Returns approximately 0.0003
F15(c(0, 0, 0, 0))  # Returns a larger value

}
\seealso{
\code{\link{test-functions}} for an overview of all test functions,
\code{\link{get_function_details}} to retrieve function parameters.
}
