% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmcorrinhom.lpp.R
\name{lmcorrinhom.lpp}
\alias{lmcorrinhom.lpp}
\title{Local mark correlation functions for inhomogeneous point patterns on linear networks.}
\usage{
\method{lmcorrinhom}{lpp}(X,
ftype = c("variogram", "stoyan", "rcorr", "shimatani",
 "beisbart", "isham", "stoyancov", "schlather"),
r = NULL,
lambda = NULL,
method_lambda = c("kernel", "Voronoi"),
bw = bw.scott.iso,
f = NULL,
method = c("density", "loess"),
normalise = TRUE,
tol = 0.01,
...)
}
\arguments{
\item{X}{An object of class lpp.}

\item{ftype}{Type of the test function \eqn{t_f}. Currently any selection of \code{"variogram", "stoyan", "rcorr", "shimatani", "beisbart", "isham", "stoyancov", "schlather"}.}

\item{r}{Optional. The values of the argument \code{r} at which the mark correlation function should be evaluated.}

\item{lambda}{Estimated intensity at data points. If not given, it will be estimated internally. See details.}

\item{method_lambda}{The method to be used for estimating intensity at data points, if \code{lambda = NULL}.}

\item{bw}{Bandwidth method to be used for estimating intensity at data points if \code{lambda = NULL} and \code{method_lambda = "kernel"}.}

\item{f}{Optional. Test function \eqn{t_f} used in the definition of the mark correlation function. If \code{ftype} is given, \eqn{t_f} should be \code{NULL}.}

\item{method}{Type of smoothing, either \code{density} or \code{loess}.}

\item{normalise}{If \code{normalise=FALSE}, only the numerator of the expression for the mark correlation function will be computed.}

\item{tol}{Tolerance used in the calculation of the conditional mean of marks. This is used only if \code{ftype} is \code{schlather}.}

\item{...}{Arguments passed to \code{\link[spatstat.univar]{unnormdensity}} or \code{\link[stats]{loess}}.}
}
\value{
A \code{data.frame} where the first column contains the values of the argument \eqn{r} at which the mark correlation function is evaluated, and the remaining columns contain the estimated values of the mark correlation function for each data point; column names correspond to the IDs of the data points.
If there are multiple numeric marks, the result will instead be a list, with each element corresponding to one of the marks.
}
\description{
Local mark correlation functions for inhomogeneous point patterns on linear networks.
}
\details{
This function computes local mark correlation functions for an inhomogeneous point pattern on a linear network. See the details of test functions used in \code{\link[markstat]{mcorrinhom.lpp}}. Technical details are given in Eckardt and Moradi (2025) and Moradi and Eckardt (2025).
}
\examples{
 library(spatstat.linnet)
 library(spatstat.geom)
 library(spatstat.explore)
 X <- rpoislpp(10, simplenet)
 marks(X) <- runif(npoints(X), 1, 10)
 lmcorrinhom.lpp(X,  ftype = "stoyan", method = "density",
                method_lambda = "kernel", bw = bw.scott.iso)
}
\references{
Moradi, M., & Eckardt, M. (2025). Inhomogeneous mark correlation functions for general marked point processes. arXiv e-prints, arXiv-2505.

Eckardt, M., & Moradi, M. (2025). Local indicators of mark association for marked spatial point processes.
}
\seealso{
\code{\link[markstat]{mcorrinhom.lpp}}.
}
\author{
Mehdi Moradi \email{m2.moradi@yahoo.com} and Matthias Eckardt
}
