% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/I_bi.R
\name{I_bi}
\alias{I_bi}
\title{Beam insolation on Mars inclined surface over time period}
\usage{
I_bi(Ls, phi, tau, Ts_start, Ts_end, beta, gamma_c)
}
\arguments{
\item{Ls}{Areocentric longitude [deg]}

\item{phi}{Planetary latitude [deg]}

\item{tau}{Atmospheric optical depth (dimensionless)}

\item{Ts_start}{Start of integration period [h]}

\item{Ts_end}{End of integration period [h]}

\item{beta}{Surface tilt/slope angle from horizontal [deg]}

\item{gamma_c}{Surface azimuth angle [deg]. Zero facing equator, east negative, west positive (-180 to +180)}
}
\value{
Beam insolation on inclined surface over specified time period [Wh/m²]
}
\description{
Calculates the direct beam solar energy received on an inclined surface between specified
start and end times. Obtained by integrating beam irradiance over the time period.
}
