% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latexMatrix.R
\name{latexMatrix}
\alias{latexMatrix}
\alias{partition}
\alias{partition.latexMatrix}
\alias{getLatex}
\alias{getLatex.latexMatrix}
\alias{getBody}
\alias{getBody.latexMatrix}
\alias{getWrapper}
\alias{getWrapper.latexMatrix}
\alias{Dim}
\alias{Dim.latexMatrix}
\alias{Nrow}
\alias{Nrow.latexMatrix}
\alias{Ncol}
\alias{Ncol.latexMatrix}
\alias{print.latexMatrix}
\alias{is.numeric.latexMatrix}
\alias{as.double.latexMatrix}
\alias{[.latexMatrix}
\alias{cbind.latexMatrix}
\alias{rbind.latexMatrix}
\alias{dimnames.latexMatrix}
\alias{Dimnames<-}
\alias{Dimnames<-.latexMatrix}
\alias{Rownames<-}
\alias{Rownames<-.latexMatrix}
\alias{Colnames<-}
\alias{Colnames<-.latexMatrix}
\title{Create and Manipulate LaTeX Representations of Matrices}
\usage{
latexMatrix(
  symbol = "x",
  nrow = "n",
  ncol = "m",
  rownames = NULL,
  colnames = NULL,
  matrix = getOption("latexMatrixEnv"),
  diag = FALSE,
  sparse = FALSE,
  zero.based = c(FALSE, FALSE),
  end.at = c("n - 1", "m - 1"),
  comma = any(zero.based),
  exponent,
  transpose = FALSE,
  show.size = FALSE,
  digits = getOption("digits") - 2,
  fractions = FALSE,
  prefix = "",
  suffix = "",
  prefix.row = "",
  prefix.col = ""
)

partition(x, ...)

\method{partition}{latexMatrix}(x, rows, columns, ...)

getLatex(x, ...)

\method{getLatex}{latexMatrix}(x, ...)

getBody(x, ...)

\method{getBody}{latexMatrix}(x, ...)

getWrapper(x, ...)

\method{getWrapper}{latexMatrix}(x, ...)

Dim(x, ...)

\method{Dim}{latexMatrix}(x, ...)

Nrow(x, ...)

\method{Nrow}{latexMatrix}(x, ...)

Ncol(x, ...)

\method{Ncol}{latexMatrix}(x, ...)

\method{print}{latexMatrix}(
  x,
  onConsole = TRUE,
  bordermatrix = getOption("print.latexMatrix")[["bordermatrix"]],
  cell.spacing = getOption("print.latexMatrix")[["cell.spacing"]],
  colname.spacing = getOption("print.latexMatrix")[["colname.spacing"]],
  text.labels = getOption("print.latexMatrix")[["text.labels"]],
  display.labels = getOption("print.latexMatrix")[["display.labels"]],
  mathtext = getOption("print.latexMatrix")[["mathtext"]],
  mathtext.size = getOption("print.latexMatrix")[["mathtext.size"]],
  ...
)

\method{is.numeric}{latexMatrix}(x)

\method{as.double}{latexMatrix}(x, locals = list(), ...)

\method{[}{latexMatrix}(x, i, j, ..., drop)

\method{cbind}{latexMatrix}(..., deparse.level)

\method{rbind}{latexMatrix}(..., deparse.level)

\method{dimnames}{latexMatrix}(x)

Dimnames(x) <- value

\method{Dimnames}{latexMatrix}(x) <- value

Rownames(x) <- value

\method{Rownames}{latexMatrix}(x) <- value

Colnames(x) <- value

\method{Colnames}{latexMatrix}(x) <- value
}
\arguments{
\item{symbol}{name for matrix elements, character string. For LaTeX symbols,
the backslash must be doubled because it is an escape character in R.
That is, you must use  \code{symbol = "\\\\beta"} to get \eqn{\beta}. Alternatively, this can be an
R matrix object, containing numbers or LaTeX code for the elements. For a row or column vector, use
\code{matrix(..., nrow=1)} or \code{matrix(..., ncol=1)}}

\item{nrow}{Number of rows, a single character representing rows symbolically, or an integer, generating
that many rows.}

\item{ncol}{Number of columns, a single character representing columns symbolically, or an integer, generating
that many columns.}

\item{rownames}{optional vector of names for the matrix rows.
if \code{symbol} is an R matrix with row names, these are used.
For a matrix with a non-numeric (e.g., \code{"m"}) number of rows,
3 names should be supplied, for the 1st, 2nd, and last rows.}

\item{colnames}{optional vector of names for the matrix columns.
if \code{symbol} is an R matrix with column names, these are used.
For a matrix with a non-numeric (e.g., \code{"n"}) number of columns,
3 names should be supplied, for the 1st, 2nd, and last columns.}

\item{matrix}{Character string giving the LaTeX matrix environment used in \code{\\begin{}}, \code{\\end{}}. Typically one of:
\describe{
   \item{\code{"pmatrix"}}{uses parentheses: \code{"(", ")"}}
   \item{\code{"bmatrix"}}{uses square brackets: \code{"[", "]"}}
   \item{\code{"Bmatrix"}}{uses braces: \code{"{", "}"}}
   \item{\code{"vmatrix"}}{uses vertical bars: \code{"|", "|"}}
   \item{\code{"Vmatrix"}}{uses double vertical bars: \code{"||", "||"}}
   \item{\code{"matrix"}}{generates a plain matrix without delimiters}
   \item{\code{"smallmatrix"}}{same as \code{"matrix"}, but for in-line use}
}
Small matrix definitions from the \code{mathtools} LaTeX package are also possible for in-line use (e.g., \code{"psmallmatrix"}). 
The default is taken from the \code{"latexMatrixEnv"} option;
if this option isn't set, then \code{"pmatrix"} is used.}

\item{diag}{logical; if \code{TRUE}, off-diagonal elements are all 0 (and \code{nrow} must == \code{ncol})}

\item{sparse}{logical; if \code{TRUE} replace 0's with empty characters to print a sparse matrix}

\item{zero.based}{logical 2-vector; start the row and/or column indices at 0 rather than 1;
the default is \code{c(FALSE, FALSE)}}

\item{end.at}{if row or column indices start at 0, should they end at \code{n - 1} and
\code{m - 1} or at \code{n} and \code{m}? (where \code{n} and \code{m} represent the
characters used to denote the number of rows and columns, respectively);
the default is \code{c("n - 1", "m - 1")}; applies only when \code{nrow}
or \code{ncol} are characters}

\item{comma}{logical; if \code{TRUE}, commas are inserted between row and column subscripts, as in
\code{x_{1,1}}; the default is \code{FALSE} except for zero-based indices.}

\item{exponent}{if specified, e.g., \code{"-1"}, or \code{"1/2"},  the exponent is applied to the matrix}

\item{transpose}{if \code{TRUE}, the transpose symbol \code{"\\top"} is appended to the matrix; this may
also be a character string, e.g., \code{"T"}, \code{"\\prime"}, \code{"\textsf{T}"} are
commonly used.}

\item{show.size}{logical; if \code{TRUE} shows the order of the matrix as an appended subscript.}

\item{digits}{for a numeric matrix, number of digits to display;}

\item{fractions}{logical; if \code{TRUE}, try to express non-integers as rational numbers, using the \code{\link[MASS]{fractions}}
function.}

\item{prefix}{optional character string to be pre-pended to each matrix element, e.g, to wrap each
element in a function like \code{"\\sqrt"} (but add braces)}

\item{suffix}{optional character string to be appended to each matrix element, e.g., for exponents
on each element}

\item{prefix.row}{optional character string to be pre-pended to each matrix row index}

\item{prefix.col}{optional character string to be pre-pended to each matrix column index}

\item{x}{a \code{"latexMatrix"} object}

\item{...}{for \code{rbind()} and \code{cbind()}, one or more 
\code{"latexMatrix"} objects with, respectively, the same number of
columns or rows;
otherwise, for compatibility with generic functions, may be ignored}

\item{rows}{row numbers \emph{after} which partition lines should
be drawn in the LaTeX printed representation of the matrix;
if omitted, then the matrix isn't partitioned by rows}

\item{columns}{column numbers \emph{after} which partition lines should
be drawn in the LaTeX printed representation of the matrix;
if omitted, then the matrix isn't partitioned by columns}

\item{onConsole}{if \code{TRUE}, the default, print the LaTeX code for
the matrix on the R console.}

\item{bordermatrix}{if \code{TRUE}, the LaTeX \code{"\bordermatrix"} macro
is used for matrices with row and/or column names. This macro
doesn't work in Markdown-based documents. The default is taken
from the \code{"bordermatrix"} element of the \code{"print.latexMatrix"} option, 
and if that option isn't set
the argument is set to \code{FALSE}.}

\item{cell.spacing}{a character whose width is used to try to even out spacing
of printed cell elements; the default is taken from the \code{"cell.spacing"}
element of the \code{"print.latexMatrix"} option, and if that option isn't set the character \code{"e"} is used.}

\item{colname.spacing}{a character whose width is used to try to even out spacing
of printed column names; the default is taken from the \code{"colname.spacing"}
element of the \code{"print.latexMatrix"} option, and if that option isn't set the character \code{"i"} is used.}

\item{text.labels}{whether to set row and column labels in text mode rather than
math model; the default is taken from the \code{"text.labels"} element of the \code{"print.latexMatrix"} option,
and if the option isn't set, the default is \code{c(row=FALSE, column=FALSE)}.}

\item{display.labels}{whether or not to display row and column labels (if they exist);
the default is taken from the \code{"display.labels"} element of the \code{"print.latexMatrix"} option, and if the option
isn't set, the default is \code{TRUE}.}

\item{mathtext}{a LaTeX command to display row/column label text in math mode;
the default is taken from the \code{"mathtext"} element of the \code{"print.latexMatrix"} option, and if the
option isn't set, the default is \code{"text"}.}

\item{mathtext.size}{a LaTeX command to control the size of row/column text
(e.g., \code{"footnotesize"}); the default is taken from the \code{"mathtext.size"} 
element of the \code{"print.latexMatrix"} option, and if
the option isn't set, the default is \code{""}. Note: Setting text
size for the row and column labels only works if \code{"text"} is used
for \code{mathtext} and if MathJax isn't used to
render LaTeX math in an HTML document.}

\item{locals}{an optional list or named numeric vector of variables to be given
specific numeric values; e.g.,
\code{locals = list(a = 1, b = 5, c = -1, d = 4)} or
\code{locals = c(a = 1, b = 5, c = -1, d = 4)}}

\item{i}{row index or indices (negative indices to omit rows)}

\item{j}{column index or indices (negative indices to omit columns)}

\item{drop}{to match the generic indexing function, ignored}

\item{deparse.level}{to match the generic \code{\link{rbind}()}
and \code{\link{cbind}()} functions; ignored}

\item{value}{for \code{"Dimnames<-()"}, a two-element list with,
respectively, character vectors of row and column names;
for  \code{"Rownames<-()"} and \code{"Colnames<-()"}, a
vector of names.}
}
\value{
\code{latexMatrix()} returns an object of class \code{"latexMatrix"}.
         This is a list which contains the LaTeX representation of the matrix as a character string 
         and other information.
         The elements in the returned object are named:
         \itemize{
         \item \code{"matrix"} (the LaTeX representation of the matrix); 
         \item \code{"dim"} (\code{nrow} and \code{ncol}); 
         \item \code{"body"} (a character matrix of LaTeX expressions for the cells of the matrix);
         \item \code{"wrapper"}(the beginning and ending lines for the LaTeX matrix environment).
         \item \code{"dimnames"}(the rownames and colnames for the matrix, if specified)
         }
         
         \code{partition()}, \code{rbind()}, \code{cbind()}, and indexing of
         \code{"latexMatrix"} objects also return a \code{"latexMatrix"} object.
}
\description{
The purpose of the \code{latexMatrix()} function is to facilitate the preparation
of LaTeX and Markdown documents that include matrices. The function generates the
the LaTeX code for matrices of various types programmatically. The objects produced
by the function can also be manipulated, e.g., with standard arithmetic functions and operators:
See \code{\link{latexMatrixOperations}}.

The \code{latexMatrix()} function can construct the LaTeX code for a symbolic matrix 
whose elements are a \code{symbol}, like \eqn{x}, with row and column subscripts.
For example, with no arguments, the call \code{latexMatrix()} generates this LaTeX representation
of an \eqn{n \times m} matrix with elements \eqn{x_{ij}}.
\preformatted{
 \\begin{pmatrix}
   x_{11}  & x_{12}  & \\dots  & x_{1m}  \\
   x_{21}  & x_{22}  & \\dots  & x_{2m}  \\
   \\vdots & \\vdots & \\ddots & \\vdots \\
   x_{n1}  & x_{n2}  & \\dots  & x_{nm}
 \\end{pmatrix}
 }

 When rendered in LaTeX, this produces:
 \deqn{
 \begin{pmatrix}
   x_{11} & x_{12} & \cdots & x_{1m} \\
   x_{21} & x_{22} & \cdots & x_{2m} \\
   \vdots & \vdots &        & \vdots \\
   x_{n1} & x_{n2} & \cdots & x_{nm} \\
 \end{pmatrix}
 }

% \figure{man/figures/symbMat-x.png}{options: width=150 alt="LaTeX result for the symbolic n x m matrix"}.

Alternatively, instead of characters,
the number of rows and/or columns can be \bold{integers}, generating a matrix of given size,
as in \code{latexMatrix(nrow = 2, ncol = 3)}.

As well, instead of a character for the matrix \code{symbol}, you can supply a \bold{matrix} of arbitrary character
strings (in LaTeX notation) or numbers, and these will be used as the elements of the matrix,
as in \code{latexMatrix(matrix(1:6, nrow = 2, ncol = 6))}.

The resulting LaTeX code is printed to the console by default. When the result is assigned to a variable,
you can send it to the clipboard using \code{\link[clipr]{write_clip}()}. Perhaps most convenient of all,
the function can be used used in a markdown chunk in a \code{Rmd} or \code{qmd} document, e.g,

\preformatted{
```{r results = "asis"}
latexMatrix("\\\\lambda", nrow=2, ncol=2,
               diag=TRUE)
```
}

This generates
\deqn{
 \begin{pmatrix}
 \lambda_{1} & 0           \\
 0           & \lambda_{2} \\
 \end{pmatrix}
 }

The function \code{\link{Eqn}} can be used to construct matrix equations, and in RStudio generates a preview of
an equation in the Viewer panel.

Various options control the printing of \code{"latexMatrix"} objects, described in Details.
}
\details{
This implementation assumes that the LaTeX \code{amsmath} package will be available because it uses the shorthands
\code{\\begin{pmatrix}}, ... rather than
\preformatted{
\\left(
  \\begin{array}(ccc)
  ...
  \\end{array}
\\right)
}

You may need to use \code{extra_dependencies: ["amsmath"]} in your YAML header of a \code{Rmd} or \code{qmd} file.

You can supply a numeric matrix as the \code{symbol}, but the result will not be pretty
unless the elements are integers or are rounded. You can control the number of digits
displayed using the global option \code{options("digits")}, for example: \code{options(digits = 4)}.
For a LaTeX representation of general numeric matrices, use
\code{\link{matrix2latex}}.

\bold{Other functions}

\code{rbind()} and \code{cbind()} join \code{"latexMatrix"} objects together, and indexing,
via \code{[ , ]} subsets rows/columns just as they do for regular matrices.

The \code{partition()} function modifies (only) the printed LaTeX representation of a \code{"latexMatrix"}
object to include partition lines by rows and/or columns.

The accessor functions \code{getLatex()}, \code{getBody()}, \code{getWrapper()},
\code{getDim()}, \code{getNrow()}, and \code{getNcol()} may be used to retrieve
components of the returned object.

Various arithmetic functions and operators (like \code{+}, \code{-}, matrix product \code{\%*\%}, ...)  for \code{"latexMatrix"} objects are
documented separately; see, \code{\link{latexMatrixOperations}}.



\bold{print.latexMatrix options}

Some LaTeX typesetting details are controlled by the \code{"print.latexMatrix"} option,
which can be a \bold{list} with one or more of the following elements (see the
arguments to the \code{print.latexMatrix()} method for more information):
\code{"bordermatrix"}, 
\code{"cell.spacing"}, 
\code{"colname.spacing"},
\code{"text.labels"}, 
\code{"display.labels"}, 
\code{"mathtext"},
and \code{"mathtext.size"}.

Most of these have to do with the display of matrices which have row and/or column labels
in their \code{\link[base]{dimnames}} or by being set with the \code{rownames} and \code{rownames} 
arguments to \code{latexMatrix}.

You can turn off their display using:

\preformatted{options(print.latexMatrix = list(display.labels=FALSE))}

and similarly you can change any other of these options.
}
\examples{
latexMatrix()

# return value
mat <- latexMatrix()
str(mat)
cat(getLatex(mat))

# copy to clipboard (can't be done in non-interactive mode)
\dontrun{
clipr::write_clip(mat) 
} 

# can use a complex symbol
latexMatrix("\\\\widehat{\\\\beta}", 2, 4)

# numeric rows/cols
latexMatrix(ncol=3)
latexMatrix(nrow=4)
latexMatrix(nrow=4, ncol=4)

# diagonal matrices
latexMatrix(nrow=3, ncol=3, diag=TRUE)
latexMatrix(nrow="n", ncol="n", diag=TRUE)
latexMatrix(nrow="n", ncol="n", diag=TRUE, sparse=TRUE)

# commas, exponents, transpose
latexMatrix("\\\\beta", comma=TRUE, exponent="-1")
latexMatrix("\\\\beta", comma=TRUE, transpose=TRUE)
latexMatrix("\\\\beta", comma=TRUE, exponent="-1", transpose=TRUE)

# for a row/column vector, wrap in matrix()
latexMatrix(matrix(LETTERS[1:4], nrow=1))
latexMatrix(matrix(LETTERS[1:4], ncol=1))

# represent the SVD, X = U D V'  symbolically
X <- latexMatrix("x", "n", "p")
U <- latexMatrix("u", "n", "k")
D <- latexMatrix("\\\\lambda", "k", "k", diag=TRUE)
V <- latexMatrix("v", "k", "p", transpose = TRUE)
cat("\\\\mathrm{SVD:}\n", getLatex(X), "=\n", getLatex(U),
    getLatex(D), getLatex(V))

# supply a matrix for 'symbol'
m <- matrix(c(
  "\\\\alpha", "\\\\beta",
  "\\\\gamma", "\\\\delta",
  "\\\\epsilon", "\\\\pi",
  0 , 0), 4, 2, byrow=TRUE)
latexMatrix(m)

# Identity matrix
latexMatrix(diag(3))
latexMatrix(diag(3), sparse=TRUE)

# prefix / suffix
latexMatrix(prefix="\\\\sqrt{", suffix="}")
latexMatrix(suffix="^{1/2}")

# show size (order) of a matrix
latexMatrix(show.size=TRUE)
latexMatrix(nrow=3, ncol=4, show.size=TRUE)

# handling fractions
m <- matrix(3/(1:9), 3, 3)
latexMatrix(m)
latexMatrix(m, digits=2)
latexMatrix(m, fractions=TRUE)

# zero-based indexing
latexMatrix(zero.based=c(TRUE, TRUE))

# partitioned matrix
X <- latexMatrix(nrow=5, ncol=6)
partition(X, rows=c(2, 4), columns=c(3, 5))

# binding rows and columns; indexing
X <- latexMatrix("x", nrow=4, ncol=2)
Y <- latexMatrix("y", nrow=4, ncol=1)
Z <- latexMatrix(matrix(1:8, 4, 2))
cbind(X, Y, Z)
rbind(X, Z)
X[1:2, ]
X[-(1:2), ]
X[1:2, 2]

# defining row and column names
W <- latexMatrix(rownames=c("\\\\alpha_1", "\\\\alpha_2", "\\\\alpha_m"),
                 colnames=c("\\\\beta_1", "\\\\beta_2", "\\\\beta_n"))
W
Rownames(W) <- c("\\\\mathrm{Abe}", "\\\\mathrm{Barry}", "\\\\mathrm{Zelda}")
Colnames(W) <- c("\\\\mathrm{Age}", "\\\\mathrm{BMI}", "\\\\mathrm{Waist}")
W
}
\seealso{
\code{\link{latexMatrixOperations}}, 
 \code{\link{Eqn}},
 \code{\link{matrix2latex}},
 \code{\link[clipr]{write_clip}}
}
\author{
John Fox
}
